/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.skills;

import javax.annotation.Nonnull;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.util.skills.Skill;
import net.dries007.tfc.util.skills.SkillTier;
import net.minecraft.nbt.NBTTagCompound;

public class SimpleSkill
extends Skill {
    private float amount = 0.0f;

    public SimpleSkill(IPlayerData rootSkills) {
        super(rootSkills);
    }

    @Override
    @Nonnull
    public SkillTier getTier() {
        return SkillTier.valueOf((int)this.amount);
    }

    @Override
    public float getLevel() {
        return this.amount >= 4.0f ? 1.0f : this.amount % 1.0f;
    }

    @Override
    public void setTotalLevel(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        this.amount = (float)value * 4.0f;
        this.updateAndSync();
    }

    public void add(float amount) {
        this.amount = (float)((double)this.amount + (double)amount / Math.pow(2.0, this.getTier().ordinal()));
        if (this.amount > 4.0f) {
            this.amount = 4.0f;
        }
        this.updateAndSync();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("amount", this.amount);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            this.amount = nbt.func_74760_g("amount");
        }
    }
}

