/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.skills;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.util.skills.Skill;
import net.dries007.tfc.util.skills.SkillTier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class ProspectingSkill
extends Skill {
    private static final double MAX_PROSPECT_DISTANCE = 192.0;
    private final Set<BlockPos> foundPositions = new HashSet<BlockPos>(40);
    private int level;

    public ProspectingSkill(IPlayerData rootSkills) {
        super(rootSkills);
    }

    @Override
    @Nonnull
    public SkillTier getTier() {
        return SkillTier.valueOf(this.level / 10);
    }

    @Override
    public float getLevel() {
        return this.level >= 40 ? 1.0f : (float)(this.level % 10) / 10.0f;
    }

    @Override
    public void setTotalLevel(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        this.level = (int)(value * 40.0);
        this.updateAndSync();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("level", this.level);
        int i = 0;
        for (BlockPos pos : this.foundPositions) {
            nbt.func_74772_a("p" + i, pos.func_177986_g());
            ++i;
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            this.level = nbt.func_74762_e("level");
            for (int i = 0; i < this.level; ++i) {
                this.foundPositions.add(BlockPos.func_177969_a((long)nbt.func_74763_f("p" + i)));
            }
        }
    }

    public void addSkill(BlockPos pos) {
        for (BlockPos foundPos : this.foundPositions) {
            if (!(pos.func_177951_i((Vec3i)foundPos) < 192.0)) continue;
            return;
        }
        this.foundPositions.add(pos);
        ++this.level;
        this.updateAndSync();
    }
}

