/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.objects.items.metal.ItemSmallOre;
import net.dries007.tfc.world.classic.worldgen.vein.VeinType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class VeinTypeJson
implements JsonDeserializer<VeinType> {
    public VeinType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ResourceLocation oreName;
        Ore ore;
        VeinType.Shape shape;
        int maxY;
        JsonObject jsonObject = JsonUtils.func_151210_l((JsonElement)json, (String)"vein");
        int minY = JsonUtils.func_151203_m((JsonObject)jsonObject, (String)"minimum_height");
        if (minY > (maxY = JsonUtils.func_151203_m((JsonObject)jsonObject, (String)"maximum_height"))) {
            throw new JsonParseException("Minimum height cannot be greater than maximum height!");
        }
        int rarity = JsonUtils.func_151203_m((JsonObject)jsonObject, (String)"rarity");
        if (rarity <= 0) {
            throw new JsonParseException("Rarity cannot be negative or zero!");
        }
        int density = JsonUtils.func_151203_m((JsonObject)jsonObject, (String)"density");
        if (density <= 0) {
            throw new JsonParseException("Density cannot be negative or zero!");
        }
        int width = JsonUtils.func_151203_m((JsonObject)jsonObject, (String)"width");
        if (width <= 0) {
            throw new JsonParseException("Width cannot be negative or zero!");
        }
        int height = JsonUtils.func_151203_m((JsonObject)jsonObject, (String)"height");
        if (height <= 0) {
            throw new JsonParseException("Height cannot be negative or zero!");
        }
        String shapeName = JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"shape");
        try {
            shape = VeinType.Shape.valueOf(shapeName.toUpperCase());
        }
        catch (IllegalArgumentException e2) {
            throw new JsonParseException("No shape '" + shapeName + "' exists.");
        }
        JsonArray rocks = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)"base_rocks");
        HashSet<Rock> blocks = new HashSet<Rock>();
        rocks.forEach(e -> {
            ResourceLocation name = new ResourceLocation(e.getAsString());
            Rock rock = (Rock)TFCRegistries.ROCKS.getValue(name);
            if (rock == null) {
                RockCategory category = (RockCategory)TFCRegistries.ROCK_CATEGORIES.getValue(name);
                if (category == null) {
                    TerraFirmaCraft.getLog().warn("Problem parsing ore entry '{}'. Rock / Rock Category '{}' is not defined. Skipping.", (Object)name, e);
                } else {
                    blocks.addAll(TFCRegistries.ROCKS.getValuesCollection().stream().filter(e1 -> e1.getRockCategory() == category).collect(Collectors.toList()));
                }
            } else {
                blocks.add(rock);
            }
        });
        ItemStack looseRock = ItemStack.field_190927_a;
        if (JsonUtils.func_151204_g((JsonObject)jsonObject, (String)"loose")) {
            ResourceLocation looseResource = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"loose"));
            Ore looseOre = (Ore)TFCRegistries.ORES.getValue(looseResource);
            ItemSmallOre smallOre = null;
            if (looseOre != null) {
                smallOre = ItemSmallOre.get(looseOre);
            }
            if (smallOre != null) {
                looseRock = new ItemStack((Item)smallOre, 1);
            } else {
                int metaLoose = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"looseMeta", (int)0);
                if (ForgeRegistries.ITEMS.containsKey(looseResource)) {
                    looseRock = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(looseResource), 1, metaLoose);
                } else if (ForgeRegistries.BLOCKS.containsKey(looseResource)) {
                    looseRock = new ItemStack((Block)ForgeRegistries.BLOCKS.getValue(looseResource), 1, metaLoose);
                } else {
                    throw new JsonParseException("Unable to parse loose rock " + looseResource + ". No registered small ore, item or block found.");
                }
            }
        }
        if ((ore = (Ore)TFCRegistries.ORES.getValue(oreName = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"ore")))) == null) {
            if (ForgeRegistries.BLOCKS.containsKey(oreName)) {
                IBlockState oreState;
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(oreName);
                int meta = JsonUtils.func_151208_a((JsonObject)jsonObject, (String)"meta", (int)0);
                try {
                    oreState = block.func_176203_a(meta);
                }
                catch (RuntimeException e3) {
                    throw new JsonParseException("Unable to find a matching IBlockState for block " + oreName + " and metadata: " + meta);
                }
                return new VeinType.CustomVeinType(oreState, looseRock, blocks, shape, width, height, rarity, minY, maxY, density);
            }
            throw new JsonParseException("Unrecognized ore '" + oreName + "'");
        }
        return new VeinType(ore, looseRock, blocks, shape, width, height, rarity, minY, maxY, density);
    }
}

