/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.damage.CapabilityDamageResistance;
import net.dries007.tfc.objects.entity.animal.AnimalFood;
import net.dries007.tfc.world.classic.worldgen.vein.VeinRegistry;
import org.apache.commons.io.FileUtils;

public enum JsonConfigRegistry {
    INSTANCE;

    private static final String DEFAULT_ANIMAL_FOOD = "assets/tfc/config/animal_food_data.json";
    private static final String DEFAULT_DAMAGE_RESISTANCE = "assets/tfc/config/entity_resistance_data.json";
    private static final String DEFAULT_ORE_SPAWN = "assets/tfc/config/ore_spawn_data.json";
    private File tfcConfigDir;

    public void preInit(File dir) {
        File defaultFile;
        TerraFirmaCraft.getLog().info("Loading or creating TFC config directory");
        this.tfcConfigDir = new File(dir, "tfc");
        if (!this.tfcConfigDir.exists() && !this.tfcConfigDir.mkdir()) {
            throw new Error("Problem creating TFC extra config directory.");
        }
        if (ConfigTFC.General.OVERRIDES.forceDefaultOreGenFile) {
            try {
                defaultFile = new File(this.tfcConfigDir, "ore_spawn_data.json");
                if (defaultFile.exists()) {
                    FileUtils.copyFile((File)defaultFile, (File)new File(defaultFile.getPath() + ".old"));
                    FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(JsonConfigRegistry.class.getClassLoader().getResourceAsStream(DEFAULT_ORE_SPAWN)), (File)defaultFile);
                } else if (defaultFile.createNewFile()) {
                    FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(JsonConfigRegistry.class.getClassLoader().getResourceAsStream(DEFAULT_ORE_SPAWN)), (File)defaultFile);
                }
            }
            catch (IOException e) {
                throw new Error("Problem creating default ore vein config file.", e);
            }
        }
        defaultFile = new File(this.tfcConfigDir, "entity_resistance_data.json");
        try {
            if (defaultFile.createNewFile()) {
                FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(JsonConfigRegistry.class.getClassLoader().getResourceAsStream(DEFAULT_DAMAGE_RESISTANCE)), (File)defaultFile);
            }
        }
        catch (IOException e) {
            throw new Error("Problem creating default entity resistance config file.", e);
        }
        defaultFile = new File(this.tfcConfigDir, "animal_food_data.json");
        try {
            if (defaultFile.createNewFile()) {
                FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(JsonConfigRegistry.class.getClassLoader().getResourceAsStream(DEFAULT_ANIMAL_FOOD)), (File)defaultFile);
            }
        }
        catch (IOException e) {
            throw new Error("Problem creating default animal food config file.", e);
        }
    }

    public void postInit() {
        Path[] recursivePathList;
        try {
            recursivePathList = (Path[])Files.walk(this.tfcConfigDir.toPath(), new FileVisitOption[0]).filter(f -> Files.isRegularFile(f, new LinkOption[0]) && f.toString().endsWith(".json")).toArray(Path[]::new);
        }
        catch (IOException e) {
            TerraFirmaCraft.getLog().error("Unable to read files in the config directory! TFC will not generate any ore veins or load any damage resitances!");
            TerraFirmaCraft.getLog().error("Error: ", (Throwable)e);
            return;
        }
        for (Path path : recursivePathList) {
            try {
                String fileContents = new String(Files.readAllBytes(path), Charset.defaultCharset());
                JsonObject jsonObject = new JsonParser().parse(fileContents).getAsJsonObject();
                JsonElement loader = jsonObject.get("#loader");
                if (loader != null && "tfc:damage_resistance".equals(loader.getAsString())) {
                    CapabilityDamageResistance.readFile(jsonObject.entrySet());
                    continue;
                }
                if (loader != null && "tfc:animal_food".equals(loader.getAsString())) {
                    AnimalFood.readFile(jsonObject.entrySet());
                    continue;
                }
                String veinPath = this.tfcConfigDir.toPath().relativize(path.getParent()).toString();
                VeinRegistry.INSTANCE.readFile(jsonObject.entrySet(), veinPath);
            }
            catch (IOException e) {
                TerraFirmaCraft.getLog().error("There was an error reading a json file at: " + path);
                TerraFirmaCraft.getLog().error("Error: ", (Throwable)e);
            }
        }
        VeinRegistry.INSTANCE.postInit();
        CapabilityDamageResistance.postInit();
    }
}

