/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.interaction;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.util.interaction.IRightClickBlockAction;
import net.dries007.tfc.util.interaction.IRightClickItemAction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

@ParametersAreNonnullByDefault
final class ClientInteractionManager {
    ClientInteractionManager() {
    }

    @Nonnull
    static EnumActionResult processRightClickBlock(PlayerInteractEvent.RightClickBlock event, IRightClickBlockAction itemUseAction) {
        EnumActionResult result = EnumActionResult.PASS;
        EntityPlayerSP player = (EntityPlayerSP)event.getEntityPlayer();
        ItemStack itemstack = event.getItemStack();
        World worldIn = event.getWorld();
        BlockPos pos = event.getPos();
        EnumHand hand = event.getHand();
        EnumFacing direction = event.getFace();
        if (direction == null) {
            direction = EnumFacing.UP;
        }
        Vec3d hitVec = event.getHitVec();
        float hitX = 0.0f;
        float hitY = 0.0f;
        float hitZ = 0.0f;
        if (hitVec != null) {
            hitX = (float)(hitVec.field_72450_a - (double)pos.func_177958_n());
            hitY = (float)(hitVec.field_72448_b - (double)pos.func_177956_o());
            hitZ = (float)(hitVec.field_72449_c - (double)pos.func_177952_p());
        }
        boolean flag = false;
        PlayerControllerMP controller = Minecraft.func_71410_x().field_71442_b;
        if (controller.func_178889_l() != GameType.SPECTATOR) {
            ItemBlock itemblock;
            boolean bypass;
            EnumActionResult ret = itemstack.onItemUseFirst((EntityPlayer)player, worldIn, pos, hand, direction, hitX, hitY, hitZ);
            if (ret != EnumActionResult.PASS) {
                return ret;
            }
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            boolean bl = bypass = player.func_184614_ca().doesSneakBypassUse((IBlockAccess)worldIn, pos, (EntityPlayer)player) && player.func_184592_cb().doesSneakBypassUse((IBlockAccess)worldIn, pos, (EntityPlayer)player);
            if (!player.func_70093_af() || bypass || event.getUseBlock() == Event.Result.ALLOW) {
                if (event.getUseBlock() != Event.Result.DENY) {
                    flag = iblockstate.func_177230_c().func_180639_a(worldIn, pos, iblockstate, (EntityPlayer)player, hand, direction, hitX, hitY, hitZ);
                }
                if (flag) {
                    result = EnumActionResult.SUCCESS;
                }
            }
            if (!flag && itemstack.func_77973_b() instanceof ItemBlock && !(itemblock = (ItemBlock)itemstack.func_77973_b()).func_179222_a(worldIn, pos, direction, (EntityPlayer)player, itemstack)) {
                return EnumActionResult.FAIL;
            }
        }
        if (!flag && controller.func_178889_l() != GameType.SPECTATOR || event.getUseItem() == Event.Result.ALLOW) {
            Block block;
            if (itemstack.func_190926_b()) {
                return EnumActionResult.PASS;
            }
            if (player.func_184811_cZ().func_185141_a(itemstack.func_77973_b())) {
                return EnumActionResult.PASS;
            }
            if (itemstack.func_77973_b() instanceof ItemBlock && !player.func_189808_dh() && ((block = ((ItemBlock)itemstack.func_77973_b()).func_179223_d()) instanceof BlockCommandBlock || block instanceof BlockStructure)) {
                return EnumActionResult.FAIL;
            }
            if (controller.func_178889_l().func_77145_d()) {
                int i = itemstack.func_77960_j();
                int j = itemstack.func_190916_E();
                if (event.getUseItem() != Event.Result.DENY) {
                    EnumActionResult enumactionresult = itemUseAction.onRightClickBlock(itemstack, (EntityPlayer)player, worldIn, pos, hand, direction, hitX, hitY, hitZ);
                    if (enumactionresult == EnumActionResult.PASS) {
                        enumactionresult = itemstack.func_179546_a((EntityPlayer)player, worldIn, pos, hand, direction, hitX, hitY, hitZ);
                    }
                    itemstack.func_77964_b(i);
                    itemstack.func_190920_e(j);
                    return enumactionresult;
                }
                return result;
            }
            ItemStack copyForUse = itemstack.func_77946_l();
            if (event.getUseItem() != Event.Result.DENY && (result = itemUseAction.onRightClickBlock(copyForUse, (EntityPlayer)player, worldIn, pos, hand, direction, hitX, hitY, hitZ)) == EnumActionResult.PASS) {
                result = copyForUse.func_179546_a((EntityPlayer)player, worldIn, pos, hand, direction, hitX, hitY, hitZ);
            }
            if (itemstack.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)copyForUse, (EnumHand)hand);
            }
            return result;
        }
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    static EnumActionResult processRightClickItem(PlayerInteractEvent.RightClickItem event, IRightClickItemAction action) {
        return action.onRightClickItem(event.getWorld(), event.getEntityPlayer(), event.getHand());
    }
}

