/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.fuel;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.util.fuel.Fuel;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public final class FuelManager {
    private static final List<Fuel> FUELS = new ArrayList<Fuel>();
    private static final Fuel EMPTY = new Fuel(IIngredient.empty(), 0, 0.0f);

    @Nonnull
    public static Fuel getFuel(ItemStack stack) {
        return FUELS.stream().filter(x -> x.matchesInput(stack)).findFirst().orElse(EMPTY);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return FuelManager.getFuel(stack) != EMPTY;
    }

    public static boolean isItemForgeFuel(ItemStack stack) {
        Fuel fuel = FuelManager.getFuel(stack);
        return fuel != EMPTY && fuel.isForgeFuel();
    }

    public static boolean isItemBloomeryFuel(ItemStack stack) {
        Fuel fuel = FuelManager.getFuel(stack);
        return fuel != EMPTY && fuel.isBloomeryFuel();
    }

    public static void postInit() {
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            BlockLogTFC log = BlockLogTFC.get(wood);
            FUELS.add(new Fuel(IIngredient.of(new ItemStack((Block)log)), wood.getBurnTicks(), wood.getBurnTemp()));
        }
        FUELS.add(new Fuel(IIngredient.of("gemCoal"), 2200, 1415.0f, true, false));
        FUELS.add(new Fuel(IIngredient.of("gemLignite"), 2000, 1350.0f, true, false));
        FUELS.add(new Fuel(IIngredient.of("charcoal"), 1800, 1350.0f, true, true));
        FUELS.add(new Fuel(IIngredient.of("peat"), 2500, 680.0f));
        FUELS.add(new Fuel(IIngredient.of("stickBundle"), 600, 900.0f));
    }

    public static void addFuel(Fuel fuel) {
        if (FuelManager.canRegister(fuel)) {
            FUELS.add(fuel);
        }
    }

    public static boolean canRegister(Fuel fuel) {
        return FUELS.stream().noneMatch(x -> x.matchesInput(fuel));
    }
}

