/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.forge;

import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.util.forge.ForgeStep;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

@ParametersAreNonnullByDefault
public class ForgeSteps
implements INBTSerializable<NBTTagCompound> {
    private final LinkedList<ForgeStep> steps = new LinkedList();

    public ForgeSteps() {
        this.reset();
    }

    public void reset() {
        for (int i = 0; i < 3; ++i) {
            this.addStep(null);
        }
    }

    public void addStep(@Nullable ForgeStep step) {
        this.steps.add(step);
        while (this.steps.size() > 3) {
            this.steps.remove();
        }
    }

    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("last", this.getStepInt(0));
        nbt.func_74768_a("second", this.getStepInt(1));
        nbt.func_74768_a("third", this.getStepInt(2));
        return nbt;
    }

    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            this.addStep(ForgeStep.valueOf(nbt.func_74762_e("last")));
            this.addStep(ForgeStep.valueOf(nbt.func_74762_e("second")));
            this.addStep(ForgeStep.valueOf(nbt.func_74762_e("third")));
        }
    }

    @Nonnull
    public ForgeSteps copy() {
        ForgeSteps newSteps = new ForgeSteps();
        for (ForgeStep step : this.steps) {
            newSteps.addStep(step);
        }
        return newSteps;
    }

    @Nullable
    public ForgeStep getStep(int idx) {
        return this.steps.get(idx);
    }

    public String toString() {
        return "[" + (Object)((Object)this.getStep(0)) + ", " + (Object)((Object)this.getStep(1)) + ", " + (Object)((Object)this.getStep(2)) + "]";
    }

    public boolean hasWork() {
        for (ForgeStep step : this.steps) {
            if (step == null) continue;
            return true;
        }
        return false;
    }

    private int getStepInt(int idx) {
        ForgeStep step = this.steps.get(idx);
        return step == null ? -1 : step.ordinal();
    }

    private void setStepInt(int position, int step) {
        this.steps.set(position, ForgeStep.valueOf(step));
    }
}

