/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.ClimateCache;
import net.dries007.tfc.util.climate.ClimateHelper;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public final class ClimateTFC {
    private static final ClimateCache CACHE = new ClimateCache();

    public static float getActualTemp(World world, BlockPos pos) {
        return ClimateTFC.getActualTemp(world, pos, 0L);
    }

    public static float getActualTemp(World world, BlockPos pos, long timeOffset) {
        ChunkDataTFC data = ChunkDataTFC.get(world, pos);
        if (data.isInitialized()) {
            return ClimateHelper.actualTemp(data.getRegionalTemp(), pos.func_177956_o(), pos.func_177952_p(), timeOffset);
        }
        return ClimateTFC.getActualTemp(pos, timeOffset);
    }

    public static float getActualTemp(BlockPos pos) {
        return ClimateTFC.getActualTemp(pos, 0L);
    }

    public static float getActualTemp(BlockPos pos, long timeOffset) {
        return ClimateHelper.actualTemp(CACHE.get(pos).getRegionalTemp(), pos.func_177956_o(), pos.func_177952_p(), timeOffset);
    }

    public static float getDailyTemp(World world, BlockPos pos) {
        return ClimateTFC.getDailyTemp(world, pos, 0L);
    }

    public static float getDailyTemp(World world, BlockPos pos, long timeOffset) {
        ChunkDataTFC data = ChunkDataTFC.get(world, pos);
        if (data.isInitialized()) {
            return ClimateHelper.dailyTemp(data.getRegionalTemp(), pos.func_177952_p(), timeOffset);
        }
        return ClimateTFC.getDailyTemp(pos, timeOffset);
    }

    public static float getDailyTemp(BlockPos pos) {
        return ClimateTFC.getDailyTemp(pos, 0L);
    }

    public static float getDailyTemp(BlockPos pos, long timeOffset) {
        return ClimateHelper.dailyTemp(CACHE.get(pos).getRegionalTemp(), pos.func_177952_p(), timeOffset);
    }

    public static float getMonthlyTemp(World world, BlockPos pos) {
        return ClimateTFC.getMonthlyTemp(world, pos, 0L);
    }

    public static float getMonthlyTemp(World world, BlockPos pos, long timeOffset) {
        ChunkDataTFC data = ChunkDataTFC.get(world, pos);
        if (data.isInitialized()) {
            return ClimateHelper.monthlyTemp(data.getRegionalTemp(), pos.func_177952_p(), timeOffset);
        }
        return ClimateTFC.getMonthlyTemp(pos, timeOffset);
    }

    public static float getMonthlyTemp(BlockPos pos) {
        return ClimateTFC.getMonthlyTemp(pos, 0L);
    }

    public static float getMonthlyTemp(BlockPos pos, long timeOffset) {
        return ClimateHelper.monthlyTemp(CACHE.get(pos).getRegionalTemp(), pos.func_177952_p(), timeOffset);
    }

    public static float getAvgTemp(World world, BlockPos pos) {
        ChunkDataTFC data = ChunkDataTFC.get(world, pos);
        if (data.isInitialized()) {
            return data.getAverageTemp();
        }
        return ClimateTFC.getAvgTemp(pos);
    }

    public static float getAvgTemp(BlockPos pos) {
        return ClimateHelper.monthFactor(CACHE.get(pos).getRegionalTemp(), Month.AVERAGE_TEMPERATURE_MODIFIER, pos.func_177952_p());
    }

    public static float getRainfall(World world, BlockPos pos) {
        return ChunkDataTFC.getRainfall(world, pos);
    }

    public static float getRainfall(BlockPos pos) {
        return CACHE.get(pos).getRainfall();
    }

    public static void update(ChunkPos pos, float temperature, float rainfall) {
        CACHE.update(pos, temperature, rainfall);
    }

    private ClimateTFC() {
    }
}

