/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.climate;

import java.util.Random;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.calendar.ICalendarFormatted;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.config.TemperatureMode;
import net.minecraft.util.math.MathHelper;

public class ClimateHelper {
    private static final Random RANDOM = new Random();

    public static float actualTemp(float regionalTemp, int y, int z, long timeOffset) {
        return ClimateHelper.dailyTemp(regionalTemp, z, timeOffset) - ClimateHelper.heightFactor(y);
    }

    public static float dailyTemp(float regionalTemp, int z, long timeOffset) {
        int hourOfDay = ICalendarFormatted.getHourOfDay(CalendarTFC.CALENDAR_TIME.getTicks() + timeOffset);
        if (hourOfDay > 12) {
            hourOfDay = 24 - hourOfDay;
        }
        float hourModifier = (float)hourOfDay / 6.0f - 1.0f;
        long day = ICalendar.getTotalDays(CalendarTFC.CALENDAR_TIME.getTicks() + timeOffset);
        RANDOM.setSeed(day);
        float dailyModifier = RANDOM.nextFloat() - RANDOM.nextFloat();
        return ClimateHelper.monthlyTemp(regionalTemp, z, timeOffset) + (dailyModifier + 0.3f * hourModifier) * 3.0f;
    }

    public static float monthlyTemp(float regionalTemp, int z, long timeOffset) {
        long time = CalendarTFC.CALENDAR_TIME.getTicks() + timeOffset;
        Month monthOfYear = ICalendarFormatted.getMonthOfYear(time, CalendarTFC.CALENDAR_TIME.getDaysInMonth());
        float currentMonthFactor = ClimateHelper.monthFactor(regionalTemp, monthOfYear, z);
        float nextMonthFactor = ClimateHelper.monthFactor(regionalTemp, monthOfYear.next(), z);
        float delta = (float)ICalendarFormatted.getDayOfMonth(time, CalendarTFC.CALENDAR_TIME.getDaysInMonth()) / (float)CalendarTFC.CALENDAR_TIME.getDaysInMonth();
        return currentMonthFactor * (1.0f - delta) + nextMonthFactor * delta;
    }

    public static float heightFactor(int y) {
        if (y > 144) {
            float scale = (float)(y - 144) * 0.16225f;
            if (scale > 17.822f) {
                scale = 17.822f;
            }
            return scale;
        }
        return 0.0f;
    }

    public static float monthFactor(float regionalTemp, Month month, int z) {
        return ClimateHelper.monthFactor(regionalTemp, month.getTemperatureModifier(), z);
    }

    public static float monthFactor(float regionalTemp, float monthTempModifier, int z) {
        return 41.0f - monthTempModifier * 1.1f * (1.0f - 0.8f * ClimateHelper.latitudeFactor(z)) + regionalTemp;
    }

    public static float latitudeFactor(int chunkZ) {
        int tempRange = ConfigTFC.General.WORLD.latitudeTemperatureModifier;
        if (ConfigTFC.General.WORLD.temperatureMode == TemperatureMode.ENDLESS) {
            chunkZ = MathHelper.func_76125_a((int)chunkZ, (int)(-tempRange / 2), (int)(tempRange / 2));
        }
        return 0.5f + 0.5f * (float)ConfigTFC.General.WORLD.hemisphereType.getValue() * (float)Math.sin(Math.PI * (double)chunkZ / (double)tempRange);
    }

    private ClimateHelper() {
    }
}

