/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.network.PacketCalendarUpdate;
import net.dries007.tfc.util.calendar.CalendarWorldData;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.calendar.ICalendarFormatted;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class CalendarTFC
implements INBTSerializable<NBTTagCompound> {
    public static final CalendarTFC INSTANCE = new CalendarTFC();
    public static final ICalendar PLAYER_TIME = () -> CalendarTFC.INSTANCE.playerTime;
    public static final ICalendarFormatted CALENDAR_TIME = new ICalendarFormatted(){

        @Override
        public long getTicks() {
            return INSTANCE.calendarTime;
        }

        @Override
        public long getDaysInMonth() {
            return INSTANCE.daysInMonth;
        }
    };
    public static final String[] DAY_NAMES = new String[]{"sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
    public static final Map<String, String> BIRTHDAYS = new HashMap<String, String>();
    private long playerTime;
    private long calendarTime;
    private int daysInMonth;
    private boolean doDaylightCycle;
    private boolean arePlayersLoggedOn;
    private MinecraftServer server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTransaction(long transactionPlayerTimeOffset, long transactionCalendarTimeOffset, Runnable transaction) {
        try {
            CalendarTFC.INSTANCE.playerTime += transactionPlayerTimeOffset;
            CalendarTFC.INSTANCE.calendarTime += transactionCalendarTimeOffset;
            transaction.run();
        }
        finally {
            CalendarTFC.INSTANCE.playerTime -= transactionPlayerTimeOffset;
            CalendarTFC.INSTANCE.calendarTime -= transactionCalendarTimeOffset;
        }
    }

    public CalendarTFC() {
        this.daysInMonth = ConfigTFC.General.MISC.defaultMonthLength;
        this.playerTime = 0L;
        this.calendarTime = 5 * this.daysInMonth * 24000 + 6000;
        this.doDaylightCycle = true;
        this.arePlayersLoggedOn = false;
    }

    public void setTimeFromCalendarTime(long calendarTimeToSetTo) {
        long timeJump = calendarTimeToSetTo - this.calendarTime;
        this.calendarTime = calendarTimeToSetTo;
        this.playerTime += timeJump;
        for (WorldServer world : this.server.field_71305_c) {
            long currentWorldTime = world.func_72820_D();
            world.func_72877_b(currentWorldTime + timeJump);
        }
        TerraFirmaCraft.getNetwork().sendToAll((IMessage)new PacketCalendarUpdate(this));
    }

    public long setTimeFromWorldTime(long worldTimeToSetTo) {
        long worldTimeJump = worldTimeToSetTo % 24000L - CALENDAR_TIME.getWorldTime();
        if (worldTimeJump < 0L) {
            worldTimeJump += 24000L;
        }
        this.calendarTime += worldTimeJump;
        this.playerTime += worldTimeJump;
        TerraFirmaCraft.getNetwork().sendToAll((IMessage)new PacketCalendarUpdate(this));
        return worldTimeJump;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("daysInMonth", this.daysInMonth);
        nbt.func_74772_a("playerTime", this.playerTime);
        nbt.func_74772_a("calendarTime", this.calendarTime);
        nbt.func_74757_a("doDaylightCycle", this.doDaylightCycle);
        nbt.func_74757_a("arePlayersLoggedOn", this.arePlayersLoggedOn);
        return nbt;
    }

    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            this.daysInMonth = nbt.func_74762_e("daysInMonth");
            this.playerTime = nbt.func_74763_f("playerTime");
            this.calendarTime = nbt.func_74763_f("calendarTime");
            this.doDaylightCycle = nbt.func_74767_n("doDaylightCycle");
            this.arePlayersLoggedOn = nbt.func_74767_n("arePlayersLoggedOn");
        }
    }

    public void write(ByteBuf buffer) {
        buffer.writeInt(this.daysInMonth);
        buffer.writeLong(this.playerTime);
        buffer.writeLong(this.calendarTime);
        buffer.writeBoolean(this.doDaylightCycle);
        buffer.writeBoolean(this.arePlayersLoggedOn);
    }

    public void read(ByteBuf buffer) {
        this.daysInMonth = buffer.readInt();
        this.playerTime = buffer.readLong();
        this.calendarTime = buffer.readLong();
        this.doDaylightCycle = buffer.readBoolean();
        this.arePlayersLoggedOn = buffer.readBoolean();
    }

    public void resetTo(CalendarTFC resetTo) {
        this.daysInMonth = resetTo.daysInMonth;
        this.playerTime = resetTo.playerTime;
        this.calendarTime = resetTo.calendarTime;
        this.doDaylightCycle = resetTo.doDaylightCycle;
        this.arePlayersLoggedOn = resetTo.arePlayersLoggedOn;
    }

    public void init(MinecraftServer server) {
        this.server = server;
        server.func_130014_f_().func_82736_K().func_82764_b("doDaylightCycle", "false");
        this.resetTo(CalendarWorldData.get(server.func_130014_f_()).getCalendar());
        TerraFirmaCraft.getNetwork().sendToAll((IMessage)new PacketCalendarUpdate(this));
    }

    public void onServerTick() {
        if (this.arePlayersLoggedOn) {
            ++this.playerTime;
        }
        if (this.server.func_71259_af() % 10 == 0) {
            TerraFirmaCraft.getNetwork().sendToAll((IMessage)new PacketCalendarUpdate(this));
        }
    }

    public void onOverworldTick(World world) {
        long deltaWorldTime;
        if (this.doDaylightCycle && this.arePlayersLoggedOn) {
            ++this.calendarTime;
        }
        if ((deltaWorldTime = world.func_72820_D() % 24000L - CALENDAR_TIME.getWorldTime()) > 1L || deltaWorldTime < -1L) {
            boolean checkArePlayersLoggedOn;
            TerraFirmaCraft.getLog().info("World time and Calendar Time are out of sync! Trying to fix...");
            TerraFirmaCraft.getLog().info("Calendar Time = {} ({}), Player Time = {}, World Time = {}, doDaylightCycle = {}, ArePlayersLoggedOn = {}", (Object)this.calendarTime, (Object)CALENDAR_TIME.getWorldTime(), (Object)this.playerTime, (Object)(world.func_72820_D() % 24000L), (Object)this.doDaylightCycle, (Object)this.arePlayersLoggedOn);
            boolean bl = checkArePlayersLoggedOn = this.server.func_184103_al().func_181057_v().size() > 0;
            if (this.arePlayersLoggedOn != checkArePlayersLoggedOn) {
                TerraFirmaCraft.getLog().info("Setting ArePlayersLoggedOn = {}", (Object)checkArePlayersLoggedOn);
                this.setPlayersLoggedOn(checkArePlayersLoggedOn);
            }
            if (deltaWorldTime < 0L) {
                world.func_72877_b(world.func_72820_D() - deltaWorldTime);
                TerraFirmaCraft.getLog().info("Calendar is ahead by {} ticks, jumping world time to catch up", (Object)(-deltaWorldTime));
            } else {
                this.calendarTime += deltaWorldTime;
                TerraFirmaCraft.getLog().info("Calendar is behind by {} ticks, jumping calendar time to catch up", (Object)deltaWorldTime);
            }
            TerraFirmaCraft.getNetwork().sendToAll((IMessage)new PacketCalendarUpdate(this));
        }
    }

    public void setMonthLength(int newMonthLength) {
        long baseMonths = CALENDAR_TIME.getTotalMonths();
        long baseDayTime = this.calendarTime - CALENDAR_TIME.getTotalDays() * 24000L;
        float monthPercent = (float)(CALENDAR_TIME.getDayOfMonth() - 1) / (float)this.daysInMonth;
        int newDayOfMonth = (int)(monthPercent * (float)newMonthLength);
        this.daysInMonth = newMonthLength;
        this.calendarTime = (baseMonths * (long)this.daysInMonth + (long)newDayOfMonth) * 24000L + baseDayTime;
        TerraFirmaCraft.getNetwork().sendToAll((IMessage)new PacketCalendarUpdate(this));
    }

    public void setPlayersLoggedOn(boolean arePlayersLoggedOn) {
        GameRules rules = this.server.func_130014_f_().func_82736_K();
        this.arePlayersLoggedOn = arePlayersLoggedOn;
        if (arePlayersLoggedOn) {
            rules.func_82764_b("doDaylightCycle", Boolean.toString(this.doDaylightCycle));
            TerraFirmaCraft.getLog().info("Reverted doDaylightCycle to {} as players are logged in.", (Object)this.doDaylightCycle);
        } else {
            rules.func_82764_b("doDaylightCycle", Boolean.toString(false));
            TerraFirmaCraft.getLog().info("Forced doDaylightCycle to false as no players are logged in. Will revert to {} as soon as a player logs in.", (Object)this.doDaylightCycle);
        }
        TerraFirmaCraft.getNetwork().sendToAll((IMessage)new PacketCalendarUpdate(this));
    }

    public void setDoDaylightCycle() {
        GameRules rules = this.server.func_130014_f_().func_82736_K();
        this.doDaylightCycle = rules.func_82766_b("doDaylightCycle");
        if (!this.arePlayersLoggedOn) {
            rules.func_82764_b("doDaylightCycle", "false");
            TerraFirmaCraft.getLog().info("Forced doDaylightCycle to false as no players are logged in. Will revert to {} as soon as a player logs in.", (Object)this.doDaylightCycle);
        }
        TerraFirmaCraft.getNetwork().sendToAll((IMessage)new PacketCalendarUpdate(this));
    }

    static {
        BIRTHDAYS.put("JULY7", "Bioxx's Birthday");
        BIRTHDAYS.put("JUNE18", "Kitty's Birthday");
        BIRTHDAYS.put("OCTOBER2", "Dunk's Birthday");
        BIRTHDAYS.put("MAY1", "Dries's Birthday");
        BIRTHDAYS.put("DECEMBER9", "Alcatraz's Birthday");
        BIRTHDAYS.put("FEBRUARY31", "Bunsan's Birthday");
        BIRTHDAYS.put("MARCH14", "Claycorp's Birthday");
        BIRTHDAYS.put("DECEMBER1", "LightningShock's Birthday");
        BIRTHDAYS.put("JANUARY20", "Therighthon's Birthday");
        BIRTHDAYS.put("FEBRUARY21", "CtrlAltDavid's Birthday");
        BIRTHDAYS.put("MARCH10", "Disastermoo's Birthday");
    }
}

