/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.block;

import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class BoundingBox {
    protected final EnumFacing direction;
    protected final double x;
    protected final double y;
    protected final double z;
    protected final double radiusX;
    protected final double radiusY;
    protected final double radiusZ;
    protected AxisAlignedBB[] values = new AxisAlignedBB[4];

    public BoundingBox(Vec3d centerPoint, double radiusX, double radiusY, double radiusZ, @Nonnull EnumFacing direction) {
        this(centerPoint.field_72450_a, centerPoint.field_72448_b, centerPoint.field_72449_c, radiusX, radiusY, radiusZ, direction);
    }

    public BoundingBox(double x, double y, double z, double radiusX, double radiusY, double radiusZ, @Nonnull EnumFacing direction) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.direction = direction;
        this.radiusX = radiusX;
        this.radiusY = radiusY;
        this.radiusZ = radiusZ;
        Arrays.fill(this.values, null);
    }

    @Nonnull
    public AxisAlignedBB getAABB(EnumFacing facing) {
        if (this.values[facing.func_176736_b()] == null) {
            if (facing == this.direction) {
                this.values[facing.func_176736_b()] = new AxisAlignedBB(this.x - this.radiusX, this.y - this.radiusY, this.z - this.radiusZ, this.x + this.radiusX, this.y + this.radiusY, this.z + this.radiusZ);
            } else {
                int rotation = facing.func_176736_b() - this.direction.func_176736_b();
                if (rotation < 0) {
                    rotation += 4;
                }
                double rad = (double)(rotation * 90) * (Math.PI / 180);
                double x = Math.cos(rad) * (this.x - 0.5) - Math.sin(rad) * (this.z - 0.5) + 0.5;
                double z = Math.sin(rad) * (this.x - 0.5) + Math.cos(rad) * (this.z - 0.5) + 0.5;
                double radiusX = rotation % 2 == 0 ? this.radiusX : this.radiusZ;
                double radiusZ = rotation % 2 == 0 ? this.radiusZ : this.radiusX;
                this.values[facing.func_176736_b()] = new AxisAlignedBB(x - radiusX, this.y - this.radiusY, z - radiusZ, x + radiusX, this.y + this.radiusY, z + radiusZ);
            }
        }
        return this.values[facing.func_176736_b()];
    }
}

