/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.agriculture;

import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.dries007.tfc.api.types.ICrop;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropDead;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropSimple;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropSpreading;
import net.dries007.tfc.objects.blocks.agriculture.BlockCropTFC;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.objects.items.food.ItemFoodTFC;
import net.dries007.tfc.util.agriculture.Food;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.skills.Skill;
import net.dries007.tfc.util.skills.SkillTier;
import net.dries007.tfc.world.classic.worldgen.WorldGenWildCrops;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum Crop implements ICrop
{
    BARLEY(Food.BARLEY, 0.0f, 1.0f, 26.0f, 33.0f, 50.0f, 70.0f, 310.0f, 330.0f, 8, 0.4f, CropType.SIMPLE),
    MAIZE(Food.MAIZE, 10.0f, 19.0f, 40.0f, 45.0f, 110.0f, 140.0f, 400.0f, 450.0f, 6, 0.6f, CropType.SIMPLE),
    OAT(Food.OAT, 0.0f, 3.0f, 30.0f, 34.0f, 50.0f, 100.0f, 350.0f, 400.0f, 8, 0.5f, CropType.SIMPLE),
    RICE(Food.RICE, 20.0f, 22.0f, 40.0f, 45.0f, 250.0f, 300.0f, 450.0f, 500.0f, 8, 0.6f, CropType.SIMPLE),
    RYE(Food.RYE, 0.0f, 4.0f, 35.0f, 40.0f, 50.0f, 100.0f, 400.0f, 450.0f, 8, 0.5f, CropType.SIMPLE),
    WHEAT(Food.WHEAT, 0.0f, 3.0f, 30.0f, 34.0f, 50.0f, 100.0f, 350.0f, 400.0f, 8, 0.5f, CropType.SIMPLE),
    BEET(Food.BEET, -5.0f, 0.0f, 20.0f, 25.0f, 50.0f, 70.0f, 300.0f, 320.0f, 7, 0.6f, CropType.SIMPLE),
    CABBAGE(Food.CABBAGE, -10.0f, 0.0f, 27.0f, 33.0f, 50.0f, 60.0f, 280.0f, 300.0f, 6, 0.6f, CropType.SIMPLE),
    CARROT(Food.CARROT, 3.0f, 10.0f, 30.0f, 36.0f, 50.0f, 100.0f, 400.0f, 450.0f, 5, 0.6f, CropType.SIMPLE),
    GARLIC(Food.GARLIC, -20.0f, -1.0f, 18.0f, 26.0f, 50.0f, 60.0f, 310.0f, 340.0f, 5, 0.65f, CropType.SIMPLE),
    GREEN_BEAN(Food.GREEN_BEAN, 2.0f, 9.0f, 35.0f, 41.0f, 70.0f, 150.0f, 410.0f, 450.0f, 7, 0.45f, CropType.PICKABLE),
    ONION(Food.ONION, -1.0f, 10.0f, 37.0f, 40.0f, 70.0f, 200.0f, 410.0f, 450.0f, 7, 0.4f, CropType.SIMPLE),
    POTATO(Food.POTATO, 0.0f, 4.0f, 30.0f, 35.0f, 50.0f, 100.0f, 390.0f, 440.0f, 7, 0.55f, CropType.SIMPLE),
    SOYBEAN(Food.SOYBEAN, 8.0f, 12.0f, 30.0f, 36.0f, 55.0f, 160.0f, 410.0f, 450.0f, 7, 0.5f, CropType.SIMPLE),
    SQUASH(Food.SQUASH, 5.0f, 14.0f, 33.0f, 37.0f, 45.0f, 90.0f, 390.0f, 440.0f, 8, 0.5f, CropType.SIMPLE),
    SUGARCANE(Food.SUGARCANE, 12.0f, 20.0f, 38.0f, 45.0f, 50.0f, 160.0f, 410.0f, 450.0f, 8, 0.5f, CropType.SIMPLE),
    TOMATO(Food.TOMATO, 0.0f, 8.0f, 36.0f, 40.0f, 50.0f, 120.0f, 390.0f, 430.0f, 8, 0.45f, CropType.PICKABLE),
    RED_BELL_PEPPER(() -> new ItemStack((Item)ItemFoodTFC.get(Food.RED_BELL_PEPPER)), () -> new ItemStack((Item)ItemFoodTFC.get(Food.GREEN_BELL_PEPPER)), 4.0f, 12.0f, 32.0f, 38.0f, 50.0f, 100.0f, 400.0f, 450.0f, 7, 0.55f, CropType.PICKABLE),
    YELLOW_BELL_PEPPER(() -> new ItemStack((Item)ItemFoodTFC.get(Food.YELLOW_BELL_PEPPER)), () -> new ItemStack((Item)ItemFoodTFC.get(Food.GREEN_BELL_PEPPER)), 4.0f, 12.0f, 32.0f, 38.0f, 50.0f, 100.0f, 400.0f, 450.0f, 7, 0.55f, CropType.PICKABLE),
    JUTE(() -> new ItemStack((Item)ItemsTFC.JUTE), () -> ItemStack.field_190927_a, 5.0f, 11.0f, 37.0f, 42.0f, 50.0f, 100.0f, 410.0f, 450.0f, 6, 0.5f, CropType.SIMPLE);

    private final Supplier<ItemStack> foodDrop;
    private final Supplier<ItemStack> foodDropEarly;
    private final float tempMinAlive;
    private final float tempMinGrow;
    private final float tempMaxGrow;
    private final float tempMaxAlive;
    private final float rainMinAlive;
    private final float rainMinGrow;
    private final float rainMaxGrow;
    private final float rainMaxAlive;
    private final int growthStages;
    private final float growthTime;
    private final CropType type;

    public static int getSkillFoodBonus(Skill skill, Random random) {
        return random.nextInt(2 + (int)(6.0f * skill.getTotalLevel()));
    }

    public static int getSkillSeedBonus(Skill skill, Random random) {
        if (skill.getTier().isAtLeast(SkillTier.ADEPT) && random.nextInt(10 - 2 * skill.getTier().ordinal()) == 0) {
            return 1;
        }
        return 0;
    }

    private Crop(Food foodDrop, float tempMinAlive, float tempMinGrow, float tempMaxGrow, float tempMaxAlive, float rainMinAlive, float rainMinGrow, float rainMaxGrow, float rainMaxAlive, int growthStages, float growthTime, CropType type) {
        this(() -> new ItemStack((Item)ItemFoodTFC.get(foodDrop)), () -> ItemStack.field_190927_a, tempMinAlive, tempMinGrow, tempMaxGrow, tempMaxAlive, rainMinAlive, rainMinGrow, rainMaxGrow, rainMaxAlive, growthStages, growthTime, type);
    }

    private Crop(Supplier<ItemStack> foodDrop, Supplier<ItemStack> foodDropEarly, float tempMinAlive, float tempMinGrow, float tempMaxGrow, float tempMaxAlive, float rainMinAlive, float rainMinGrow, float rainMaxGrow, float rainMaxAlive, int growthStages, float growthTime, CropType type) {
        this.foodDrop = foodDrop;
        this.foodDropEarly = foodDropEarly;
        this.tempMinAlive = tempMinAlive;
        this.tempMinGrow = tempMinGrow;
        this.tempMaxGrow = tempMaxGrow;
        this.tempMaxAlive = tempMaxAlive;
        this.rainMinAlive = rainMinAlive;
        this.rainMinGrow = rainMinGrow;
        this.rainMaxGrow = rainMaxGrow;
        this.rainMaxAlive = rainMaxAlive;
        this.growthStages = growthStages;
        this.growthTime = growthTime;
        this.type = type;
    }

    @Override
    public long getGrowthTicks() {
        return (long)(this.growthTime * (float)CalendarTFC.CALENDAR_TIME.getDaysInMonth() * 24000.0f);
    }

    @Override
    public int getMaxStage() {
        return this.growthStages - 1;
    }

    @Override
    public boolean isValidConditions(float temperature, float rainfall) {
        return this.tempMinAlive < temperature && temperature < this.tempMaxAlive && this.rainMinAlive < rainfall && rainfall < this.rainMaxAlive;
    }

    @Override
    public boolean isValidForGrowth(float temperature, float rainfall) {
        return this.tempMinGrow < temperature && temperature < this.tempMaxGrow && this.rainMinGrow < rainfall && rainfall < this.rainMaxGrow;
    }

    @Override
    @Nonnull
    public ItemStack getFoodDrop(int currentStage) {
        if (currentStage == this.getMaxStage()) {
            return this.foodDrop.get();
        }
        if (currentStage == this.getMaxStage() - 1) {
            return this.foodDropEarly.get();
        }
        return ItemStack.field_190927_a;
    }

    public BlockCropTFC createGrowingBlock() {
        if (this.type == CropType.SIMPLE || this.type == CropType.PICKABLE) {
            return BlockCropSimple.create(this, this.type == CropType.PICKABLE);
        }
        if (this.type == CropType.SPREADING) {
            return BlockCropSpreading.create(this);
        }
        throw new IllegalStateException("Invalid growthstage property " + this.growthStages + " for crop");
    }

    public BlockCropDead createDeadBlock() {
        return new BlockCropDead(this);
    }

    static {
        for (Crop crop : Crop.values()) {
            WorldGenWildCrops.register(crop);
        }
    }

    static enum CropType {
        SIMPLE,
        PICKABLE,
        SPREADING;

    }
}

