/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.agriculture;

import net.dries007.tfc.api.types.IBerryBush;
import net.dries007.tfc.objects.items.food.ItemFoodTFC;
import net.dries007.tfc.util.agriculture.Food;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.world.classic.worldgen.WorldGenBerryBushes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum BerryBush implements IBerryBush
{
    BLACKBERRY(Food.BLACKBERRY, Month.MAY, 4, 7.0f, 20.0f, 100.0f, 400.0f, 0.8f, IBerryBush.Size.LARGE, true),
    BLUEBERRY(Food.BLUEBERRY, Month.JUNE, 3, 7.0f, 25.0f, 100.0f, 400.0f, 0.8f, IBerryBush.Size.LARGE, false),
    BUNCH_BERRY(Food.BUNCH_BERRY, Month.JUNE, 3, 15.0f, 30.0f, 100.0f, 400.0f, 0.8f, IBerryBush.Size.SMALL, false),
    CLOUD_BERRY(Food.CLOUD_BERRY, Month.JUNE, 2, 3.0f, 17.0f, 100.0f, 400.0f, 0.8f, IBerryBush.Size.MEDIUM, false),
    CRANBERRY(Food.CRANBERRY, Month.AUGUST, 3, 1.0f, 19.0f, 100.0f, 400.0f, 0.8f, IBerryBush.Size.MEDIUM, false),
    ELDERBERRY(Food.ELDERBERRY, Month.JULY, 2, 10.0f, 29.0f, 100.0f, 400.0f, 0.8f, IBerryBush.Size.LARGE, false),
    GOOSEBERRY(Food.GOOSEBERRY, Month.MARCH, 4, 5.0f, 27.0f, 100.0f, 400.0f, 0.8f, IBerryBush.Size.MEDIUM, false),
    RASPBERRY(Food.RASPBERRY, Month.JUNE, 2, 5.0f, 20.0f, 100.0f, 400.0f, 0.8f, IBerryBush.Size.LARGE, true),
    SNOW_BERRY(Food.SNOW_BERRY, Month.JULY, 2, -5.0f, 18.0f, 100.0f, 400.0f, 0.8f, IBerryBush.Size.SMALL, false),
    STRAWBERRY(Food.STRAWBERRY, Month.MARCH, 3, 5.0f, 28.0f, 100.0f, 400.0f, 0.8f, IBerryBush.Size.SMALL, false),
    WINTERGREEN_BERRY(Food.WINTERGREEN_BERRY, Month.AUGUST, 2, -5.0f, 17.0f, 100.0f, 400.0f, 0.8f, IBerryBush.Size.SMALL, false);

    private final Food fruit;
    private final Month harvestMonthStart;
    private final int harvestingMonths;
    private final float growthTime;
    private final float minTemp;
    private final float maxTemp;
    private final float minRain;
    private final float maxRain;
    private final IBerryBush.Size size;
    private final boolean hasSpikes;

    private BerryBush(Food fruit, Month harvestMonthStart, int harvestingMonths, float minTemp, float maxTemp, float minRain, float maxRain, float growthTime, IBerryBush.Size size, boolean spiky) {
        this.fruit = fruit;
        this.harvestMonthStart = harvestMonthStart;
        this.harvestingMonths = harvestingMonths;
        this.growthTime = growthTime * (float)CalendarTFC.CALENDAR_TIME.getDaysInMonth() * 24.0f;
        this.minTemp = minTemp;
        this.maxTemp = maxTemp;
        this.minRain = minRain;
        this.maxRain = maxRain;
        this.size = size;
        this.hasSpikes = spiky;
    }

    public Food getFruit() {
        return this.fruit;
    }

    @Override
    public float getGrowthTime() {
        return this.growthTime;
    }

    @Override
    public boolean isHarvestMonth(Month month) {
        Month testing = this.harvestMonthStart;
        for (int i = 0; i < this.harvestingMonths; ++i) {
            if (testing.equals((Object)month)) {
                return true;
            }
            testing = testing.next();
        }
        return false;
    }

    @Override
    public boolean isValidConditions(float temperature, float rainfall) {
        return this.minTemp - 5.0f < temperature && temperature < this.maxTemp + 5.0f && this.minRain - 50.0f < rainfall && rainfall < this.maxRain + 50.0f;
    }

    @Override
    public boolean isValidForGrowth(float temperature, float rainfall) {
        return this.minTemp < temperature && temperature < this.maxTemp && this.minRain < rainfall && rainfall < this.maxRain;
    }

    @Override
    public ItemStack getFoodDrop() {
        return new ItemStack((Item)ItemFoodTFC.get(this.getFruit()));
    }

    @Override
    public IBerryBush.Size getSize() {
        return this.size;
    }

    @Override
    public boolean isSpiky() {
        return this.hasSpikes;
    }

    static {
        for (BerryBush bush : BerryBush.values()) {
            WorldGenBerryBushes.register(bush);
        }
    }
}

