/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.dries007.tfc.world.classic.worldgen.WorldGenBerryBushes;
import net.dries007.tfc.world.classic.worldgen.WorldGenLooseRocks;
import net.dries007.tfc.world.classic.worldgen.WorldGenSnowIce;
import net.dries007.tfc.world.classic.worldgen.WorldGenTrees;
import net.dries007.tfc.world.classic.worldgen.WorldGenWildCrops;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="tfc")
public final class WorldRegenHandler {
    private static final WorldGenLooseRocks ROCKS_GEN = new WorldGenLooseRocks(false);
    private static final WorldGenSnowIce SNOW_GEN = new WorldGenSnowIce();
    private static final WorldGenWildCrops CROPS_GEN = new WorldGenWildCrops();
    private static final WorldGenBerryBushes BUSH_GEN = new WorldGenBerryBushes();
    private static final Random RANDOM = new Random();
    private static final List<ChunkPos> POSITIONS = new LinkedList<ChunkPos>();

    @SubscribeEvent
    public static void onChunkLoad(ChunkDataEvent.Load event) {
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END && !POSITIONS.isEmpty()) {
            ChunkPos pos = POSITIONS.remove(0);
            ChunkDataTFC chunkDataTFC = ChunkDataTFC.get(event.world, pos.func_180331_a(0, 0, 0));
            IChunkProvider chunkProvider = event.world.func_72863_F();
            IChunkGenerator chunkGenerator = ((ChunkProviderServer)chunkProvider).field_186029_c;
            long updateDelta = CalendarTFC.PLAYER_TIME.getTicks() - chunkDataTFC.getLastUpdateTick();
            if (updateDelta > (long)(ConfigTFC.General.WORLD_REGEN.minimumTime * 24000) && !chunkDataTFC.isSpawnProtected()) {
                float regenerationModifier = MathHelper.func_76131_a((float)((float)updateDelta / (float)(4 * ConfigTFC.General.WORLD_REGEN.minimumTime * 24000)), (float)0.0f, (float)1.0f);
                if (ConfigTFC.General.WORLD_REGEN.sticksRocksModifier > 0.0) {
                    double rockModifier = ConfigTFC.General.WORLD_REGEN.sticksRocksModifier * (double)regenerationModifier;
                    ROCKS_GEN.setFactor(rockModifier);
                    ROCKS_GEN.generate(RANDOM, pos.field_77276_a, pos.field_77275_b, event.world, chunkGenerator, chunkProvider);
                    int stickDensity = (int)(rockModifier * (double)(1 + (int)(3.0f * chunkDataTFC.getFloraDensity())));
                    WorldGenTrees.generateLooseSticks(RANDOM, pos.field_77276_a, pos.field_77275_b, event.world, stickDensity);
                }
                chunkDataTFC.resetLastUpdateTick();
            }
            if (CalendarTFC.CALENDAR_TIME.getMonthOfYear().isWithin(Month.APRIL, Month.JULY) && !chunkDataTFC.isSpawnProtected() && CalendarTFC.CALENDAR_TIME.getTotalYears() > chunkDataTFC.getLastUpdateYear()) {
                if (RANDOM.nextInt(20) == 0) {
                    CROPS_GEN.generate(RANDOM, pos.field_77276_a, pos.field_77275_b, event.world, chunkGenerator, chunkProvider);
                }
                BUSH_GEN.generate(RANDOM, pos.field_77276_a, pos.field_77275_b, event.world, chunkGenerator, chunkProvider);
                chunkDataTFC.resetLastUpdateYear();
            }
            if (updateDelta > 96000L) {
                SNOW_GEN.generate(RANDOM, pos.field_77276_a, pos.field_77275_b, event.world, chunkGenerator, chunkProvider);
            }
        }
    }
}

