/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.damage.DamageType;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.objects.Powder;
import net.dries007.tfc.objects.blocks.BlockDecorativeStone;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.items.ItemPowder;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryHelper {
    private static final Multimap<Thing, String> MAP = HashMultimap.create();
    private static final Converter<String, String> UPPER_UNDERSCORE_TO_LOWER_CAMEL = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL);
    private static final Joiner JOINER_UNDERSCORE = Joiner.on((char)'_').skipNulls();
    private static boolean done = false;

    public static String toString(Object ... parts) {
        return (String)UPPER_UNDERSCORE_TO_LOWER_CAMEL.convert((Object)JOINER_UNDERSCORE.join(parts));
    }

    public static String toString(Iterable<Object> parts) {
        return (String)UPPER_UNDERSCORE_TO_LOWER_CAMEL.convert((Object)JOINER_UNDERSCORE.join(parts));
    }

    public static String toString(Object[] prefix, Object ... parts) {
        return OreDictionaryHelper.toString((Iterable<Object>)ImmutableList.builder().add(prefix).add(parts).build());
    }

    public static void register(Block thing, Object ... parts) {
        OreDictionaryHelper.register(new Thing(thing), parts);
    }

    public static void register(Item thing, Object ... parts) {
        OreDictionaryHelper.register(new Thing(thing), parts);
    }

    public static void registerMeta(Item thing, int meta, Object ... parts) {
        OreDictionaryHelper.register(new Thing(thing, meta), parts);
    }

    public static void registerRockType(Block thing, Rock.Type type, Object ... prefixParts) {
        OreDictionaryHelper.registerRockType(new Thing(thing), type, prefixParts);
    }

    public static void registerDamageType(Item thing, DamageType type) {
        OreDictionaryHelper.register(thing, "damage", "type", type.name().toLowerCase());
    }

    public static void init() {
        done = true;
        MAP.forEach((t, s) -> OreDictionary.registerOre((String)s, (ItemStack)((Thing)t).toItemStack()));
        MAP.clear();
        OreDictionary.registerOre((String)"clay", (Item)Items.field_151119_aD);
        OreDictionary.registerOre((String)"gemCoal", (ItemStack)new ItemStack(Items.field_151044_h, 1, 0));
        OreDictionary.registerOre((String)"charcoal", (ItemStack)new ItemStack(Items.field_151044_h, 1, 1));
        OreDictionary.registerOre((String)"fireStarter", (ItemStack)new ItemStack(Items.field_151033_d, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"fireStarter", (ItemStack)new ItemStack(Items.field_151059_bz));
        OreDictionary.registerOre((String)"bowl", (Item)Items.field_151054_z);
        OreDictionary.registerOre((String)"blockClay", (Block)Blocks.field_150435_aG);
        OreDictionary.registerOre((String)"bed", (ItemStack)new ItemStack(Items.field_151104_aV, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"carpet", (ItemStack)new ItemStack(Blocks.field_150404_cg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"powderConcrete", (ItemStack)new ItemStack(Blocks.field_192444_dS, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"terracotta", (ItemStack)new ItemStack(Blocks.field_150405_ch, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"terracotta", (ItemStack)new ItemStack(Blocks.field_150406_ce, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"dyePink", (ItemStack)new ItemStack((Item)ItemPowder.get(Powder.KAOLINITE)));
        OreDictionary.registerOre((String)"dyeGray", (ItemStack)new ItemStack((Item)ItemPowder.get(Powder.GRAPHITE)));
        OreDictionary.registerOre((String)"dyeRed", (ItemStack)new ItemStack((Item)ItemPowder.get(Powder.HEMATITE)));
        OreDictionary.registerOre((String)"dyeBlue", (ItemStack)new ItemStack((Item)ItemPowder.get(Powder.LAPIS_LAZULI)));
        OreDictionary.registerOre((String)"dyeYellow", (ItemStack)new ItemStack((Item)ItemPowder.get(Powder.LIMONITE)));
        OreDictionary.registerOre((String)"dyeGreen", (ItemStack)new ItemStack((Item)ItemPowder.get(Powder.MALACHITE)));
        OreDictionary.registerOre((String)"dyeBrown", (ItemStack)new ItemStack((Item)ItemPowder.get(Powder.FERTILIZER)));
        OreDictionary.registerOre((String)"dyeBlack", (ItemStack)new ItemStack((Item)ItemPowder.get(Powder.CHARCOAL)));
        OreDictionary.registerOre((String)"dyeBlack", (ItemStack)new ItemStack((Item)ItemPowder.get(Powder.COKE)));
        BlockDecorativeStone.ALABASTER_BRICKS.forEach((dyeColor, blockDecorativeStone) -> OreDictionary.registerOre((String)"alabasterBricks", (ItemStack)new ItemStack((Block)blockDecorativeStone)));
        BlockDecorativeStone.ALABASTER_BRICKS.forEach((dyeColor, blockDecorativeStone) -> OreDictionary.registerOre((String)"bricksAlabaster", (ItemStack)new ItemStack((Block)blockDecorativeStone)));
        BlockDecorativeStone.ALABASTER_POLISHED.forEach((dyeColor, blockDecorativeStone) -> OreDictionary.registerOre((String)"alabasterPolished", (ItemStack)new ItemStack((Block)blockDecorativeStone)));
        BlockDecorativeStone.ALABASTER_RAW.forEach((dyeColor, blockDecorativeStone) -> OreDictionary.registerOre((String)"alabasterRaw", (ItemStack)new ItemStack((Block)blockDecorativeStone)));
        OreDictionary.registerOre((String)"alabasterBricks", (ItemStack)new ItemStack((Block)BlocksTFC.ALABASTER_BRICKS_PLAIN));
        OreDictionary.registerOre((String)"bricksAlabaster", (ItemStack)new ItemStack((Block)BlocksTFC.ALABASTER_BRICKS_PLAIN));
        OreDictionary.registerOre((String)"alabasterRaw", (ItemStack)new ItemStack((Block)BlocksTFC.ALABASTER_RAW_PLAIN));
        OreDictionary.registerOre((String)"alabasterPolished", (ItemStack)new ItemStack((Block)BlocksTFC.ALABASTER_POLISHED_PLAIN));
        OreDictionary.getOres((String)"infiniteFire", (boolean)true);
    }

    public static boolean doesStackMatchOre(@Nonnull ItemStack stack, String name) {
        if (!OreDictionary.doesOreNameExist((String)name)) {
            TerraFirmaCraft.getLog().warn("doesStackMatchOre called with non-existing name. stack: {} name: {}", (Object)stack, (Object)name);
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        int needle = OreDictionary.getOreID((String)name);
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (id != needle) continue;
            return true;
        }
        return false;
    }

    private static void register(Thing thing, Object ... parts) {
        if (done) {
            throw new IllegalStateException("Cannot use the helper to register after postInit has past.");
        }
        MAP.put((Object)thing, (Object)OreDictionaryHelper.toString(parts));
    }

    private static void registerRockType(Thing thing, Rock.Type type, Object ... prefixParts) {
        switch (type) {
            case RAW: {
                MAP.put((Object)thing, (Object)OreDictionaryHelper.toString(prefixParts, new Object[]{"stone"}));
                break;
            }
            case SMOOTH: {
                MAP.put((Object)thing, (Object)OreDictionaryHelper.toString(prefixParts, new Object[]{"stone", "polished"}));
                break;
            }
            case COBBLE: {
                MAP.put((Object)thing, (Object)OreDictionaryHelper.toString(prefixParts, new Object[]{"cobblestone"}));
                break;
            }
            case BRICKS: {
                MAP.put((Object)thing, (Object)OreDictionaryHelper.toString(prefixParts, new Object[]{"stone", "brick"}));
                MAP.put((Object)thing, (Object)OreDictionaryHelper.toString(prefixParts, new Object[]{"brick", "stone"}));
                break;
            }
            case DRY_GRASS: {
                MAP.put((Object)thing, (Object)OreDictionaryHelper.toString(prefixParts, new Object[]{type, "dry"}));
                break;
            }
            case CLAY: {
                MAP.put((Object)thing, (Object)OreDictionaryHelper.toString(prefixParts, new Object[]{"block", type, "dirt"}));
                break;
            }
            case CLAY_GRASS: {
                MAP.put((Object)thing, (Object)OreDictionaryHelper.toString(prefixParts, new Object[]{"block", type}));
                break;
            }
            default: {
                MAP.put((Object)thing, (Object)OreDictionaryHelper.toString(prefixParts, new Object[]{type}));
            }
        }
    }

    private static class Thing {
        private final Block block;
        private final Item item;
        private final int meta;

        private Thing(Block thing) {
            this.block = thing;
            this.item = null;
            this.meta = 0;
        }

        private Thing(Item thing) {
            this(thing, -1);
        }

        private Thing(Item thing, int meta) {
            this.block = null;
            this.item = thing;
            this.meta = meta;
        }

        private ItemStack toItemStack() {
            if (this.block != null) {
                return new ItemStack(this.block, 1, this.meta);
            }
            if (this.item != null) {
                int meta = this.meta;
                if (meta == -1 && this.item.func_77645_m()) {
                    meta = Short.MAX_VALUE;
                }
                return new ItemStack(this.item, 1, meta);
            }
            return ItemStack.field_190927_a;
        }
    }
}

