/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.items.metal.ItemMetal;
import net.dries007.tfc.objects.items.metal.ItemMetalArmor;
import net.dries007.tfc.objects.items.metal.ItemMetalSword;
import net.dries007.tfc.util.collections.WeightedCollection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class MonsterEquipment {
    private static final Map<String, MonsterEquipment> ENTRIES = new HashMap<String, MonsterEquipment>();
    private final Map<EntityEquipmentSlot, WeightedCollection<ItemStack>> equipment;

    @Nullable
    public static MonsterEquipment get(Entity entity) {
        ResourceLocation entityType = EntityList.func_191301_a((Entity)entity);
        if (entityType != null) {
            String entityTypeName = entityType.toString();
            return ENTRIES.get(entityTypeName);
        }
        return null;
    }

    @Nullable
    public static MonsterEquipment get(String entityId) {
        return ENTRIES.get(entityId);
    }

    public static void put(String entityId, MonsterEquipment equipment) {
        ENTRIES.put(entityId, equipment);
    }

    public MonsterEquipment(WeightedCollection<ItemStack> weapons, WeightedCollection<ItemStack> helmets, WeightedCollection<ItemStack> chestplates, WeightedCollection<ItemStack> leggings, WeightedCollection<ItemStack> boots) {
        this.equipment = new ImmutableMap.Builder().put((Object)EntityEquipmentSlot.MAINHAND, weapons).put((Object)EntityEquipmentSlot.HEAD, helmets).put((Object)EntityEquipmentSlot.CHEST, chestplates).put((Object)EntityEquipmentSlot.LEGS, leggings).put((Object)EntityEquipmentSlot.FEET, boots).build();
    }

    public Optional<ItemStack> getEquipment(EntityEquipmentSlot slot, Random random) {
        if (this.equipment.containsKey(slot)) {
            return Optional.of(this.equipment.get(slot).getRandomEntry(random));
        }
        return Optional.empty();
    }

    static {
        WeightedCollection<ItemStack> weapons = new WeightedCollection<ItemStack>();
        weapons.add(0.4, ItemStack.field_190927_a);
        weapons.add(0.2, new ItemStack(ItemMetal.get(Metal.WROUGHT_IRON, Metal.ItemType.MACE)));
        weapons.add(0.2, new ItemStack((Item)ItemMetalSword.get(Metal.WROUGHT_IRON)));
        weapons.add(0.2, new ItemStack(ItemMetal.get(Metal.WROUGHT_IRON, Metal.ItemType.KNIFE)));
        WeightedCollection<ItemStack> rangedWeapons = new WeightedCollection<ItemStack>();
        rangedWeapons.add(0.7, new ItemStack((Item)Items.field_151031_f));
        rangedWeapons.add(0.1, new ItemStack(ItemMetal.get(Metal.WROUGHT_IRON, Metal.ItemType.MACE)));
        rangedWeapons.add(0.1, new ItemStack((Item)ItemMetalSword.get(Metal.WROUGHT_IRON)));
        rangedWeapons.add(0.2, new ItemStack(ItemMetal.get(Metal.WROUGHT_IRON, Metal.ItemType.KNIFE)));
        WeightedCollection<ItemStack> helmets = new WeightedCollection<ItemStack>();
        helmets.add(0.8, ItemStack.field_190927_a);
        helmets.add(0.2, new ItemStack((Item)ItemMetalArmor.get(Metal.WROUGHT_IRON, Metal.ItemType.HELMET)));
        WeightedCollection<ItemStack> chestplates = new WeightedCollection<ItemStack>();
        chestplates.add(0.8, ItemStack.field_190927_a);
        chestplates.add(0.2, new ItemStack((Item)ItemMetalArmor.get(Metal.WROUGHT_IRON, Metal.ItemType.CHESTPLATE)));
        WeightedCollection<ItemStack> leggings = new WeightedCollection<ItemStack>();
        leggings.add(0.8, ItemStack.field_190927_a);
        leggings.add(0.2, new ItemStack((Item)ItemMetalArmor.get(Metal.WROUGHT_IRON, Metal.ItemType.GREAVES)));
        WeightedCollection<ItemStack> boots = new WeightedCollection<ItemStack>();
        boots.add(0.8, ItemStack.field_190927_a);
        boots.add(0.2, new ItemStack((Item)ItemMetalArmor.get(Metal.WROUGHT_IRON, Metal.ItemType.BOOTS)));
        MonsterEquipment equipment = new MonsterEquipment(weapons, helmets, chestplates, leggings, boots);
        MonsterEquipment rangedEquipment = new MonsterEquipment(rangedWeapons, helmets, chestplates, leggings, boots);
        ENTRIES.put("minecraft:skeleton", rangedEquipment);
        ENTRIES.put("minecraft:stray", rangedEquipment);
        ENTRIES.put("minecraft:zombie", equipment);
        ENTRIES.put("minecraft:husk", equipment);
        ENTRIES.put("minecraft:zombie_villager", equipment);
    }
}

