/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.objects.blocks.BlockCharcoalPile;
import net.dries007.tfc.objects.blocks.wood.BlockSupport;
import net.dries007.tfc.objects.entity.EntityFallingBlockTFC;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IFallingBlock {
    public static final Set<Material> SOFT_MATERIALS = new HashSet<Material>(Arrays.asList(Material.field_151578_c, Material.field_151595_p, Material.field_151577_b, Material.field_151571_B));
    public static final Set<Material> HARD_MATERIALS = new HashSet<Material>(Arrays.asList(Material.field_151573_f, BlockCharcoalPile.CHARCOAL_MATERIAL));

    public static boolean canFallThrough(World world, BlockPos pos, Material fallingBlockMaterial) {
        IBlockState targetState = world.func_180495_p(pos);
        if (SOFT_MATERIALS.contains(fallingBlockMaterial) && HARD_MATERIALS.contains(targetState.func_185904_a())) {
            return false;
        }
        if (!world.isSideSolid(pos, EnumFacing.UP)) {
            return true;
        }
        return !targetState.func_185913_b();
    }

    default public boolean shouldFall(World world, BlockPos posToFallAt, BlockPos originalPos) {
        return this.shouldFall(world, posToFallAt, originalPos, false);
    }

    default public boolean shouldFall(World world, BlockPos posToFallAt, BlockPos originalPos, boolean ignoreSupportChecks) {
        return ConfigTFC.General.FALLABLE.enable && IFallingBlock.canFallThrough(world, posToFallAt.func_177977_b(), world.func_180495_p(originalPos).func_185904_a()) && (ignoreSupportChecks || !BlockSupport.isBeingSupported(world, originalPos));
    }

    @Nullable
    public BlockPos getFallablePos(World var1, BlockPos var2, boolean var3);

    default public BlockPos getFallablePos(World world, BlockPos pos) {
        return this.getFallablePos(world, pos, false);
    }

    default public boolean checkFalling(World worldIn, BlockPos pos, IBlockState state) {
        return this.checkFalling(worldIn, pos, state, false);
    }

    default public boolean checkFalling(World worldIn, BlockPos pos, IBlockState state, boolean ignoreSupportChecks) {
        BlockPos pos1;
        if (worldIn.func_175707_a(pos.func_177982_a(-2, -2, -2), pos.func_177982_a(2, 2, 2)) && (pos1 = this.getFallablePos(worldIn, pos, ignoreSupportChecks)) != null) {
            if (!BlockFalling.field_149832_M && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!pos1.equals((Object)pos)) {
                    worldIn.func_175698_g(pos);
                    worldIn.func_175656_a(pos1, state);
                }
                worldIn.func_72838_d((Entity)new EntityFallingBlockTFC(worldIn, pos1, this, worldIn.func_180495_p(pos1)));
            } else {
                worldIn.func_175698_g(pos);
                pos1 = pos1.func_177977_b();
                while (IFallingBlock.canFallThrough(worldIn, pos1, state.func_185904_a()) && pos1.func_177956_o() > 0) {
                    pos1 = pos1.func_177977_b();
                }
                if (pos1.func_177956_o() > 0) {
                    worldIn.func_175656_a(pos1.func_177984_a(), state);
                }
            }
            return true;
        }
        return false;
    }

    default public Iterable<ItemStack> getDropsFromFall(World world, BlockPos pos, IBlockState state, @Nullable NBTTagCompound teData, int fallTime, float fallDistance) {
        return ImmutableList.of((Object)new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state)));
    }
}

