/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public final class FluidTransferHelper {
    @Nonnull
    public static FluidActionResult tryPickUpFluidGreedy(@Nonnull ItemStack emptyContainer, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumFacing side, int maxAmount, boolean consumeOnInfiniteFluids) {
        ItemStack containerCopy;
        IFluidHandlerItem containerFluidHandler;
        IFluidHandler targetFluidHandler;
        if (emptyContainer.func_190926_b() || worldIn == null || pos == null) {
            return FluidActionResult.FAILURE;
        }
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        if ((block instanceof IFluidBlock || block instanceof BlockLiquid) && (targetFluidHandler = FluidUtil.getFluidHandler((World)worldIn, (BlockPos)pos, (EnumFacing)side)) != null && (containerFluidHandler = FluidUtil.getFluidHandler((ItemStack)(containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)emptyContainer, (int)1)))) != null && containerFluidHandler.fill(targetFluidHandler.drain(maxAmount, false), false) > 0) {
            boolean canCreateSources = false;
            if (block instanceof BlockFluidClassic) {
                BlockFluidClassic fluidblock = (BlockFluidClassic)worldIn.func_180495_p(pos).func_177230_c();
                canCreateSources = (Boolean)ObfuscationReflectionHelper.getPrivateValue(BlockFluidClassic.class, (Object)fluidblock, (String)"canCreateSources");
            } else if (block instanceof BlockLiquid) {
                canCreateSources = ForgeEventFactory.canCreateFluidSource((World)worldIn, (BlockPos)pos, (IBlockState)state, (state.func_185904_a() == Material.field_151586_h ? 1 : 0) != 0);
            }
            FluidStack drained = targetFluidHandler.drain(maxAmount, consumeOnInfiniteFluids || !canCreateSources);
            if (drained != null) {
                containerFluidHandler.fill(drained, true);
                SoundEvent soundevent = drained.getFluid().getFillSound(drained);
                if (playerIn.func_184614_ca().func_77973_b() == ItemsTFC.FIRED_JUG) {
                    soundevent = TFCSounds.JUG_FILL;
                }
                playerIn.field_70170_p.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u + 0.5, playerIn.field_70161_v, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult tryFillContainer(@Nonnull ItemStack container, IFluidHandler fluidSource, int maxAmount, @Nullable EntityPlayer player, boolean doFill) {
        FluidStack simulatedTransfer;
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler((ItemStack)containerCopy);
        if (containerFluidHandler != null && (simulatedTransfer = FluidTransferHelper.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, false)) != null) {
            if (doFill) {
                FluidTransferHelper.tryFluidTransfer((IFluidHandler)containerFluidHandler, fluidSource, maxAmount, true);
                if (player != null) {
                    SoundEvent soundevent = simulatedTransfer.getFluid().getFillSound(simulatedTransfer);
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                containerFluidHandler.fill(simulatedTransfer, true);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult emptyContainerIntoTank(@Nonnull ItemStack container, IFluidHandler fluidDestination, IItemHandler returnInventory, int returnSlot, int maxAmount, @Nullable World world, @Nullable BlockPos pos) {
        ItemStack remainder;
        FluidActionResult emptiedSimulated;
        if (!container.func_190926_b() && (emptiedSimulated = FluidTransferHelper.tryEmptyContainer(container, fluidDestination, maxAmount, false, null, null)).isSuccess() && (remainder = returnInventory.insertItem(returnSlot, emptiedSimulated.getResult(), true)).func_190926_b()) {
            FluidActionResult emptiedReal = FluidTransferHelper.tryEmptyContainer(container, fluidDestination, maxAmount, true, world, pos);
            returnInventory.insertItem(returnSlot, emptiedReal.getResult(), false);
            ItemStack containerCopy = container.func_77946_l();
            containerCopy.func_190918_g(1);
            return new FluidActionResult(containerCopy);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    public static FluidActionResult fillContainerFromTank(@Nonnull ItemStack container, IFluidHandler fluidSource, IItemHandler returnInventory, int returnSlot, int maxAmount, @Nullable World world, @Nullable BlockPos pos) {
        ItemStack remainder;
        FluidActionResult filledSimulated = FluidTransferHelper.tryFillContainer(container, fluidSource, maxAmount, false, null, null);
        if (filledSimulated.isSuccess() && (remainder = returnInventory.insertItem(returnSlot, filledSimulated.getResult(), true)).func_190926_b()) {
            FluidActionResult filledReal = FluidTransferHelper.tryFillContainer(container, fluidSource, maxAmount, true, world, pos);
            returnInventory.insertItem(returnSlot, filledReal.getResult(), false);
            ItemStack containerCopy = container.func_77946_l();
            containerCopy.func_190918_g(1);
            return new FluidActionResult(containerCopy);
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    private static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, boolean doDrain, @Nullable World world, @Nullable BlockPos pos) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler((ItemStack)containerCopy);
        if (containerFluidHandler != null) {
            if (doDrain) {
                FluidStack transfer = FluidTransferHelper.tryFluidTransfer(fluidDestination, (IFluidHandler)containerFluidHandler, maxAmount, true);
                if (transfer != null) {
                    if (world != null && pos != null) {
                        world.func_184133_a(null, pos, transfer.getFluid().getEmptySound(transfer), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    ItemStack resultContainer = containerFluidHandler.getContainer();
                    return new FluidActionResult(resultContainer);
                }
            } else {
                FluidStack simulatedTransfer = FluidTransferHelper.tryFluidTransfer(fluidDestination, (IFluidHandler)containerFluidHandler, maxAmount, false);
                if (simulatedTransfer != null) {
                    containerFluidHandler.drain(simulatedTransfer, true);
                    ItemStack resultContainer = containerFluidHandler.getContainer();
                    return new FluidActionResult(resultContainer);
                }
            }
        }
        return FluidActionResult.FAILURE;
    }

    @Nonnull
    private static FluidActionResult tryFillContainer(@Nonnull ItemStack container, IFluidHandler fluidSource, int maxAmount, boolean doFill, @Nullable World world, @Nullable BlockPos pos) {
        FluidStack simulatedTransfer;
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler((ItemStack)containerCopy);
        if (containerFluidHandler != null && (simulatedTransfer = FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, (IFluidHandler)fluidSource, (int)maxAmount, (boolean)false)) != null) {
            if (doFill) {
                FluidUtil.tryFluidTransfer((IFluidHandler)containerFluidHandler, (IFluidHandler)fluidSource, (int)maxAmount, (boolean)true);
                if (world != null && pos != null) {
                    world.func_184133_a(null, pos, simulatedTransfer.getFluid().getFillSound(simulatedTransfer), SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            } else {
                containerFluidHandler.fill(simulatedTransfer, true);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }
        return FluidActionResult.FAILURE;
    }

    @Nullable
    private static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        FluidStack drainable = fluidSource.drain(maxAmount, false);
        if (drainable != null && drainable.amount > 0) {
            return FluidTransferHelper.tryFluidTransfer_Internal(fluidDestination, fluidSource, drainable, doTransfer);
        }
        return null;
    }

    @Nullable
    private static FluidStack tryFluidTransfer_Internal(IFluidHandler fluidDestination, IFluidHandler fluidSource, FluidStack drainable, boolean doTransfer) {
        int fillableAmount = fluidDestination.fill(drainable, false);
        if (fillableAmount > 0) {
            if (doTransfer) {
                FluidStack drained = fluidSource.drain(fillableAmount, true);
                if (drained != null) {
                    drained.amount = fluidDestination.fill(drained, true);
                    return drained;
                }
            } else {
                FluidStack drained = fluidSource.drain(fillableAmount, false);
                if (drained != null) {
                    drainable.amount = fillableAmount;
                    return drainable;
                }
            }
        }
        return null;
    }
}

