/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.types;

import java.util.LinkedHashMap;
import java.util.Map;
import net.dries007.tfc.api.recipes.AlloyRecipe;
import net.dries007.tfc.api.recipes.BlastFurnaceRecipe;
import net.dries007.tfc.api.recipes.BloomeryRecipe;
import net.dries007.tfc.api.recipes.ChiselRecipe;
import net.dries007.tfc.api.recipes.LoomRecipe;
import net.dries007.tfc.api.recipes.WeldingRecipe;
import net.dries007.tfc.api.recipes.anvil.AnvilRecipe;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.api.recipes.knapping.KnappingRecipe;
import net.dries007.tfc.api.recipes.quern.QuernRecipe;
import net.dries007.tfc.api.registries.TFCRegistryEvent;
import net.dries007.tfc.api.registries.TFCRegistryNames;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.api.types.Tree;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="tfc")
public final class Registries {
    private static final Map<ResourceLocation, IForgeRegistry<?>> preBlockRegistries = new LinkedHashMap();

    @SubscribeEvent
    public static void onNewRegistryEvent(RegistryEvent.NewRegistry event) {
        Registries.newRegistry(TFCRegistryNames.ROCK_TYPE, RockCategory.class, true);
        Registries.newRegistry(TFCRegistryNames.ROCK, Rock.class, true);
        Registries.newRegistry(TFCRegistryNames.METAL, Metal.class, true);
        Registries.newRegistry(TFCRegistryNames.ORE, Ore.class, true);
        Registries.newRegistry(TFCRegistryNames.TREE, Tree.class, true);
        Registries.newRegistry(TFCRegistryNames.PLANT, Plant.class, true);
        Registries.newRegistry(TFCRegistryNames.ALLOY_RECIPE, AlloyRecipe.class, false);
        Registries.newRegistry(TFCRegistryNames.KNAPPING_RECIPE, KnappingRecipe.class, false);
        Registries.newRegistry(TFCRegistryNames.ANVIL_RECIPE, AnvilRecipe.class, false);
        Registries.newRegistry(TFCRegistryNames.WELDING_RECIPE, WeldingRecipe.class, false);
        Registries.newRegistry(TFCRegistryNames.HEAT_RECIPE, HeatRecipe.class, false);
        Registries.newRegistry(TFCRegistryNames.BARREL_RECIPE, BarrelRecipe.class, false);
        Registries.newRegistry(TFCRegistryNames.LOOM_RECIPE, LoomRecipe.class, false);
        Registries.newRegistry(TFCRegistryNames.QUERN_RECIPE, QuernRecipe.class, false);
        Registries.newRegistry(TFCRegistryNames.CHISEL_RECIPE, ChiselRecipe.class, false);
        Registries.newRegistry(TFCRegistryNames.BLOOMERY_RECIPE, BloomeryRecipe.class, false);
        Registries.newRegistry(TFCRegistryNames.BLAST_FURNACE_RECIPE, BlastFurnaceRecipe.class, false);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRegisterBlock(RegistryEvent.Register<Block> event) {
        preBlockRegistries.forEach((e, r) -> MinecraftForge.EVENT_BUS.post(new TFCRegistryEvent.RegisterPreBlock((ResourceLocation)e, r)));
    }

    private static <T extends IForgeRegistryEntry<T>> void newRegistry(ResourceLocation name, Class<T> tClass, boolean isPreBlockRegistry) {
        IForgeRegistry reg = new RegistryBuilder().setName(name).allowModification().setType(tClass).create();
        if (isPreBlockRegistry) {
            preBlockRegistries.put(name, reg);
        }
    }
}

