/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.Constants;
import net.dries007.tfc.objects.blocks.BlockPowderKeg;
import net.dries007.tfc.objects.inventory.capability.IItemHandlerSidedCallback;
import net.dries007.tfc.objects.inventory.capability.ItemHandlerSidedWrapper;
import net.dries007.tfc.objects.te.TETickableInventory;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
public class TEPowderKeg
extends TETickableInventory
implements IItemHandlerSidedCallback {
    private boolean sealed;
    private int fuse = -1;
    private boolean isLit = false;
    private EntityLivingBase igniter;

    public TEPowderKeg() {
        super(new ItemStackHandler(12));
    }

    public void readFromItemTag(NBTTagCompound nbt) {
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        this.sealed = nbt.func_74767_n("sealed");
        this.markForSync();
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.sealed = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockPowderKeg.SEALED);
        }
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack, EnumFacing side) {
        return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockPowderKeg.SEALED) == false && this.isItemValid(slot, stack);
    }

    @Override
    public boolean canExtract(int slot, EnumFacing side) {
        return !this.sealed;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public void setSealed(boolean sealed) {
        this.sealed = sealed;
        this.markForSync();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.sealed = nbt.func_74767_n("sealed");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74757_a("sealed", this.sealed);
        return super.func_189515_b(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new ItemHandlerSidedWrapper(this, (IItemHandlerModifiable)this.inventory, facing);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void onBreakBlock(World world, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockPowderKeg.SEALED)).booleanValue()) {
            super.onBreakBlock(world, pos, state);
        } else {
            ItemStack stack = this.getItemStack(state);
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return OreDictionaryHelper.doesStackMatchOre(stack, "gunpowder");
    }

    public void setIgniter(@Nullable EntityLivingBase igniterIn) {
        this.igniter = igniterIn;
    }

    public int getStrength() {
        int count = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            count += this.inventory.getStackInSlot(i).func_190916_E();
        }
        return count / 12;
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean isLit() {
        return this.isLit;
    }

    public void setLit(boolean lit) {
        this.isLit = lit;
        if (lit) {
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.33f);
            this.fuse = 80;
        } else {
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.8f, 0.6f + Constants.RNG.nextFloat() * 0.4f);
            this.fuse = -1;
        }
        this.markForSync();
    }

    @Override
    public void func_73660_a() {
        if (this.isLit) {
            --this.fuse;
            if (this.fuse <= 0) {
                this.field_145850_b.func_180501_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P(), 11);
                if (!this.field_145850_b.field_72995_K) {
                    this.explode();
                }
            }
        }
        super.func_73660_a();
    }

    public ItemStack getItemStack(IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c());
        stack.func_77982_d(this.getItemTag());
        return stack;
    }

    private NBTTagCompound getItemTag() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74757_a("sealed", this.sealed);
        return nbt;
    }

    private void explode() {
        this.field_145850_b.func_72876_a((Entity)this.igniter, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (float)this.getStrength(), true);
    }
}

