/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.size.CapabilityItemSize;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.objects.blocks.BlockLargeVessel;
import net.dries007.tfc.objects.inventory.capability.IItemHandlerSidedCallback;
import net.dries007.tfc.objects.inventory.capability.ItemHandlerSidedWrapper;
import net.dries007.tfc.objects.te.TEInventory;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.ICalendarFormatted;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
public class TELargeVessel
extends TEInventory
implements IItemHandlerSidedCallback {
    private boolean sealed;
    private long sealedTick;
    private long sealedCalendarTick;

    public TELargeVessel() {
        super(new LargeVesselItemStackHandler(9));
    }

    public void readFromItemTag(NBTTagCompound nbt) {
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        this.sealedTick = nbt.func_74763_f("sealedTick");
        this.sealedCalendarTick = nbt.func_74763_f("sealedCalendarTick");
        this.sealed = true;
        this.markForSync();
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            this.sealed = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockLargeVessel.SEALED);
        }
    }

    @Nonnull
    public String getSealedDate() {
        return ICalendarFormatted.getTimeAndDate(this.sealedCalendarTick, CalendarTFC.CALENDAR_TIME.getDaysInMonth());
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack, EnumFacing side) {
        return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockLargeVessel.SEALED) == false && this.isItemValid(slot, stack);
    }

    @Override
    public boolean canExtract(int slot, EnumFacing side) {
        return !this.sealed;
    }

    public void onSealed() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            CapabilityFood.applyTrait(this.inventory.getStackInSlot(i), FoodTrait.PRESERVED);
        }
        this.sealedTick = CalendarTFC.PLAYER_TIME.getTicks();
        this.sealedCalendarTick = CalendarTFC.CALENDAR_TIME.getTicks();
        this.sealed = true;
        this.markForSync();
    }

    public void onUnseal() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            CapabilityFood.removeTrait(this.inventory.getStackInSlot(i), FoodTrait.PRESERVED);
        }
        this.sealedCalendarTick = 0L;
        this.sealedTick = 0L;
        this.sealed = false;
        this.markForSync();
    }

    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.sealedTick = nbt.func_74763_f("sealedTick");
        this.sealedCalendarTick = nbt.func_74763_f("sealedCalendarTick");
        this.sealed = this.sealedTick > 0L;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("sealedTick", this.sealedTick);
        nbt.func_74772_a("sealedCalendarTick", this.sealedCalendarTick);
        return super.func_189515_b(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new ItemHandlerSidedWrapper(this, (IItemHandlerModifiable)this.inventory, facing);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void onBreakBlock(World world, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockLargeVessel.SEALED)).booleanValue()) {
            super.onBreakBlock(world, pos, state);
        } else {
            ItemStack stack = new ItemStack(state.func_177230_c());
            stack.func_77982_d(this.getItemTag());
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        }
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        IItemSize sizeCap = CapabilityItemSize.getIItemSize(stack);
        if (sizeCap != null) {
            return sizeCap.getSize(stack).isSmallerThan(Size.LARGE);
        }
        return true;
    }

    private NBTTagCompound getItemTag() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74772_a("sealedTick", this.sealedTick);
        nbt.func_74772_a("sealedCalendarTick", this.sealedCalendarTick);
        return nbt;
    }

    private static class LargeVesselItemStackHandler
    extends ItemStackHandler {
        private LargeVesselItemStackHandler(int slots) {
            super(slots);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stack = super.extractItem(slot, amount, simulate);
            CapabilityFood.removeTrait(stack, FoodTrait.PRESERVED);
            return stack;
        }
    }
}

