/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.capability.food.Nutrient;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.Heat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.objects.blocks.devices.BlockFirePit;
import net.dries007.tfc.objects.inventory.capability.IItemHandlerSidedCallback;
import net.dries007.tfc.objects.inventory.capability.ItemHandlerSidedWrapper;
import net.dries007.tfc.objects.items.food.ItemDynamicBowlFood;
import net.dries007.tfc.objects.items.food.ItemFoodTFC;
import net.dries007.tfc.objects.te.ITileFields;
import net.dries007.tfc.objects.te.TETickableInventory;
import net.dries007.tfc.util.agriculture.Food;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.fuel.Fuel;
import net.dries007.tfc.util.fuel.FuelManager;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
public class TEFirePit
extends TETickableInventory
implements ICalendarTickable,
ITileFields,
IItemHandlerSidedCallback {
    public static final int SLOT_FUEL_CONSUME = 0;
    public static final int SLOT_FUEL_INPUT = 3;
    public static final int SLOT_ITEM_INPUT = 4;
    public static final int SLOT_OUTPUT_1 = 5;
    public static final int SLOT_OUTPUT_2 = 6;
    public static final int SLOT_EXTRA_INPUT_START = 7;
    public static final int SLOT_EXTRA_INPUT_END = 11;
    public static final int FIELD_TEMPERATURE = 0;
    public static final int FIELD_COOKING_POT_STAGE = 1;
    public static final int FIELD_COOKING_POT_SERVINGS = 2;
    public static final float COOKING_POT_BOILING_TEMPERATURE = Heat.VERY_HOT.getMin();
    private final IItemHandler[] inventoryWrappers;
    private final Queue<ItemStack> leftover = new LinkedList<ItemStack>();
    private final HeatRecipe[] cachedGrillRecipes;
    private HeatRecipe cachedRecipe = null;
    private boolean requiresSlotUpdate = false;
    private float temperature = 0.0f;
    private int burnTicks = 0;
    private int airTicks;
    private float burnTemperature = 0.0f;
    private long lastPlayerTick = CalendarTFC.PLAYER_TIME.getTicks();
    private ItemStack attachedItemStack = ItemStack.field_190927_a;
    private CookingPotStage cookingPotStage = CookingPotStage.EMPTY;
    private int boilingTicks = 0;
    private FoodData soupContents = null;
    private int soupServings = 0;
    private Nutrient soupNutrient = null;
    private long soupCreationDate = 0L;

    public TEFirePit() {
        super(12);
        this.cachedGrillRecipes = new HeatRecipe[5];
        this.inventoryWrappers = (IItemHandler[])Arrays.stream(EnumFacing.values()).map(e -> new ItemHandlerSidedWrapper(this, (IItemHandlerModifiable)this.inventory, (EnumFacing)e)).toArray(IItemHandler[]::new);
    }

    public void onRainDrop() {
        this.burnTicks -= ConfigTFC.Devices.FIRE_PIT.rainTicks;
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.8f, 0.8f + Constants.RNG.nextFloat() * 0.4f);
    }

    @Override
    public void func_73660_a() {
        block20: {
            block22: {
                BlockFirePit.FirePitAttachment attachment;
                block23: {
                    block25: {
                        block24: {
                            block21: {
                                ItemStack stack;
                                IItemHeat cap;
                                float targetTemperature;
                                super.func_73660_a();
                                this.checkForCalendarUpdate();
                                if (this.field_145850_b.field_72995_K) break block20;
                                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                                if (((Boolean)state.func_177229_b((IProperty)BlockFirePit.LIT)).booleanValue()) {
                                    if (this.burnTicks > 0) {
                                        this.burnTicks -= this.airTicks > 0 ? 2 : 1;
                                    }
                                    if (this.burnTicks <= 0) {
                                        ItemStack stack2 = this.inventory.getStackInSlot(0);
                                        if (stack2.func_190926_b()) {
                                            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockFirePit.LIT, (Comparable)Boolean.valueOf(false)));
                                            this.burnTicks = 0;
                                            this.burnTemperature = 0.0f;
                                        } else {
                                            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                                            this.requiresSlotUpdate = true;
                                            Fuel fuel = FuelManager.getFuel(stack2);
                                            this.burnTicks += fuel.getAmount();
                                            this.burnTemperature = fuel.getTemperature();
                                        }
                                    }
                                }
                                this.airTicks = this.airTicks > 0 ? --this.airTicks : 0;
                                if ((this.temperature > 0.0f || this.burnTemperature > 0.0f) && this.temperature != (targetTemperature = this.burnTemperature + (float)this.airTicks)) {
                                    float delta = (float)ConfigTFC.Devices.TEMPERATURE.heatingModifier;
                                    this.temperature = CapabilityItemHeat.adjustTempTowards(this.temperature, targetTemperature, delta * (float)(this.airTicks > 0 ? 2 : 1), delta * (this.airTicks > 0 ? 0.5f : 1.0f));
                                }
                                if ((attachment = (BlockFirePit.FirePitAttachment)((Object)state.func_177229_b(BlockFirePit.ATTACHMENT))) != BlockFirePit.FirePitAttachment.NONE) break block21;
                                this.markForSync();
                                if (this.temperature > 0.0f && (cap = (IItemHeat)(stack = this.inventory.getStackInSlot(4)).getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null)) != null) {
                                    float itemTemp = cap.getTemperature();
                                    if (this.temperature > itemTemp) {
                                        CapabilityItemHeat.addTemp(cap);
                                    }
                                    this.handleInputMelting(stack);
                                }
                                if (this.leftover.isEmpty()) break block22;
                                ItemStack outputStack = this.leftover.peek();
                                if (!(outputStack = this.mergeOutputStack(outputStack)).func_190926_b()) break block22;
                                this.leftover.poll();
                                break block22;
                            }
                            if (attachment != BlockFirePit.FirePitAttachment.COOKING_POT) break block23;
                            if (this.cookingPotStage != CookingPotStage.WAITING) break block24;
                            this.markForSync();
                            if (this.temperature > COOKING_POT_BOILING_TEMPERATURE) {
                                this.cookingPotStage = CookingPotStage.BOILING;
                                this.boilingTicks = 0;
                            }
                            break block22;
                        }
                        if (this.cookingPotStage != CookingPotStage.BOILING) break block22;
                        if (!(this.temperature < COOKING_POT_BOILING_TEMPERATURE)) break block25;
                        this.cookingPotStage = CookingPotStage.WAITING;
                        this.boilingTicks = 0;
                        break block22;
                    }
                    ++this.boilingTicks;
                    if (this.boilingTicks <= ConfigTFC.Devices.FIRE_PIT.ticks) break block22;
                    float water = 20.0f;
                    float saturation = 2.0f;
                    float[] nutrition = new float[Nutrient.TOTAL];
                    int ingredientCount = 0;
                    for (int i = 7; i <= 11; ++i) {
                        ItemStack ingredient = this.inventory.getStackInSlot(i);
                        IFood food = (IFood)ingredient.getCapability(CapabilityFood.CAPABILITY, null);
                        if (food != null) {
                            if (food.isRotten()) {
                                ingredientCount = 0;
                                break;
                            }
                            water += food.getData().getWater();
                            saturation += food.getData().getSaturation();
                            float[] ingredientNutrition = food.getData().getNutrients();
                            Nutrient[] nutrientArray = Nutrient.values();
                            int n = nutrientArray.length;
                            for (int j = 0; j < n; ++j) {
                                Nutrient nutrient = nutrientArray[j];
                                int n2 = nutrient.ordinal();
                                nutrition[n2] = nutrition[n2] + ingredientNutrition[nutrient.ordinal()];
                            }
                            ++ingredientCount;
                        }
                        this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
                    }
                    if (ingredientCount > 0) {
                        float multiplier = 1.0f - 0.05f * (float)ingredientCount;
                        water *= multiplier;
                        saturation *= multiplier;
                        Nutrient maxNutrient = Nutrient.GRAIN;
                        float maxNutrientValue = 0.0f;
                        for (Nutrient nutrient : Nutrient.values()) {
                            int n = nutrient.ordinal();
                            nutrition[n] = nutrition[n] * multiplier;
                            if (!(nutrition[nutrient.ordinal()] > maxNutrientValue)) continue;
                            maxNutrientValue = nutrition[nutrient.ordinal()];
                            maxNutrient = nutrient;
                        }
                        this.soupContents = new FoodData(4, water, saturation, nutrition, Food.SOUP_GRAIN.getData().getDecayModifier());
                        this.soupServings = (int)((float)ingredientCount / 2.0f) + 1;
                        this.soupNutrient = maxNutrient;
                        this.soupCreationDate = CapabilityFood.getRoundedCreationDate();
                        this.cookingPotStage = CookingPotStage.FINISHED;
                    } else {
                        this.cookingPotStage = CookingPotStage.EMPTY;
                    }
                    break block22;
                }
                if (attachment == BlockFirePit.FirePitAttachment.GRILL) {
                    for (int i = 7; i <= 11; ++i) {
                        ItemStack stack = this.inventory.getStackInSlot(i);
                        IItemHeat cap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                        if (cap == null) continue;
                        float itemTemp = cap.getTemperature();
                        if (this.temperature > itemTemp) {
                            CapabilityItemHeat.addTemp(cap);
                        }
                        this.handleGrillCooking(i, stack, cap);
                    }
                }
            }
            if (this.requiresSlotUpdate) {
                this.cascadeFuelSlots();
            }
            this.func_70296_d();
        }
    }

    @Override
    public void onCalendarUpdate(long deltaPlayerTicks) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!((Boolean)state.func_177229_b((IProperty)BlockFirePit.LIT)).booleanValue()) {
            return;
        }
        if ((long)this.burnTicks > deltaPlayerTicks) {
            this.burnTicks = (int)((long)this.burnTicks - deltaPlayerTicks);
            return;
        }
        deltaPlayerTicks -= (long)this.burnTicks;
        this.burnTicks = 0;
        this.requiresSlotUpdate = true;
        for (int i = 0; i <= 3; ++i) {
            ItemStack fuelStack = this.inventory.getStackInSlot(i);
            Fuel fuel = FuelManager.getFuel(fuelStack);
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            if ((long)fuel.getAmount() > deltaPlayerTicks) {
                this.burnTicks = (int)((long)fuel.getAmount() - deltaPlayerTicks);
                this.burnTemperature = fuel.getTemperature();
                return;
            }
            deltaPlayerTicks -= (long)fuel.getAmount();
            this.burnTicks = 0;
        }
        if (deltaPlayerTicks > 0L) {
            this.burnTemperature = 0.0f;
            this.temperature = 0.0f;
            ItemStack stack = this.inventory.getStackInSlot(4);
            IItemHeat cap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
            if (cap != null) {
                cap.setTemperature(0.0f);
            }
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockFirePit.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public long getLastUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    public void setLastUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        this.func_70296_d();
        this.requiresSlotUpdate = true;
        this.cachedRecipe = HeatRecipe.get(this.inventory.getStackInSlot(4));
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockFirePit.ATTACHMENT) == BlockFirePit.FirePitAttachment.GRILL) {
            this.updateCachedGrillRecipes();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.temperature = nbt.func_74760_g("temperature");
        this.burnTicks = nbt.func_74762_e("burnTicks");
        this.airTicks = nbt.func_74762_e("airTicks");
        this.burnTemperature = nbt.func_74760_g("burnTemperature");
        this.lastPlayerTick = nbt.func_74763_f("lastPlayerTick");
        if (nbt.func_74764_b("leftover")) {
            NBTTagList surplusItems = nbt.func_150295_c("leftover", 10);
            for (int i = 0; i < surplusItems.func_74745_c(); ++i) {
                this.leftover.add(new ItemStack(surplusItems.func_150305_b(i)));
            }
        }
        this.attachedItemStack = new ItemStack(nbt.func_74775_l("attachedItemStack"));
        BlockFirePit.FirePitAttachment attachment = BlockFirePit.FirePitAttachment.valueOf(nbt.func_74762_e("attachment"));
        if (attachment == BlockFirePit.FirePitAttachment.COOKING_POT) {
            this.cookingPotStage = CookingPotStage.valueOf(nbt.func_74762_e("cookingPotStage"));
            if (this.cookingPotStage == CookingPotStage.FINISHED) {
                this.soupServings = nbt.func_74762_e("soupServings");
                this.soupNutrient = Nutrient.valueOf(nbt.func_74762_e("soupNutrient"));
                this.soupContents = new FoodData();
                this.soupContents.deserializeNBT(nbt.func_74775_l("soupContents"));
                this.soupCreationDate = nbt.func_74763_f("soupCreationDate");
            } else if (this.cookingPotStage == CookingPotStage.BOILING) {
                this.boilingTicks = nbt.func_74762_e("boilingTicks");
            }
        }
        super.func_145839_a(nbt);
        this.cachedRecipe = HeatRecipe.get(this.inventory.getStackInSlot(4));
        if (attachment == BlockFirePit.FirePitAttachment.GRILL) {
            this.updateCachedGrillRecipes();
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74776_a("temperature", this.temperature);
        nbt.func_74768_a("burnTicks", this.burnTicks);
        nbt.func_74776_a("burnTemperature", this.burnTemperature);
        nbt.func_74772_a("lastPlayerTick", this.lastPlayerTick);
        if (!this.leftover.isEmpty()) {
            NBTTagList surplusList = new NBTTagList();
            for (ItemStack stack : this.leftover) {
                surplusList.func_74742_a((NBTBase)stack.serializeNBT());
            }
            nbt.func_74782_a("leftover", (NBTBase)surplusList);
        }
        nbt.func_74782_a("attachedItemStack", (NBTBase)this.attachedItemStack.serializeNBT());
        BlockFirePit.FirePitAttachment attachment = (BlockFirePit.FirePitAttachment)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockFirePit.ATTACHMENT));
        nbt.func_74768_a("attachment", attachment.ordinal());
        if (attachment == BlockFirePit.FirePitAttachment.COOKING_POT) {
            nbt.func_74768_a("cookingPotStage", this.cookingPotStage.ordinal());
            if (this.cookingPotStage == CookingPotStage.BOILING) {
                nbt.func_74768_a("boilingTicks", this.boilingTicks);
            } else if (this.cookingPotStage == CookingPotStage.FINISHED) {
                nbt.func_74782_a("soupContents", (NBTBase)this.soupContents.serializeNBT());
                nbt.func_74768_a("soupNutrient", this.soupNutrient.ordinal());
                nbt.func_74768_a("soupServings", this.soupServings);
                nbt.func_74772_a("soupCreationDate", this.soupCreationDate);
            }
        }
        return super.func_189515_b(nbt);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new ItemHandlerSidedWrapper(this, (IItemHandlerModifiable)this.inventory, facing);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void onBreakBlock(World world, BlockPos pos, IBlockState state) {
        if (!this.attachedItemStack.func_190926_b()) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)this.attachedItemStack);
        }
        super.onBreakBlock(world, pos, state);
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot == 5 || slot == 6 ? 64 : 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        switch (slot) {
            case 3: {
                return FuelManager.isItemFuel(stack) && !FuelManager.isItemForgeFuel(stack);
            }
            case 4: {
                return stack.hasCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
            }
            case 5: 
            case 6: {
                return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && stack.hasCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                BlockFirePit.FirePitAttachment attachment = (BlockFirePit.FirePitAttachment)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockFirePit.ATTACHMENT));
                if (attachment == BlockFirePit.FirePitAttachment.COOKING_POT) {
                    return stack.hasCapability(CapabilityFood.CAPABILITY, null) && Food.Category.doesStackMatchCategories(stack, Food.Category.FRUIT, Food.Category.VEGETABLE, Food.Category.COOKED_MEAT, Food.Category.MEAT);
                }
                if (attachment != BlockFirePit.FirePitAttachment.GRILL) break;
                return stack.hasCapability(CapabilityFood.CAPABILITY, null) && stack.hasCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
            }
        }
        return false;
    }

    public void onCreate(ItemStack log) {
        Fuel fuel = FuelManager.getFuel(log);
        this.burnTicks = fuel.getAmount();
        this.burnTemperature = fuel.getTemperature();
    }

    public int getSoupServings() {
        return this.soupServings;
    }

    public void onConvertToCookingPot(EntityPlayer player, ItemStack stack) {
        this.dumpNonExtraItems(player);
        this.cookingPotStage = CookingPotStage.EMPTY;
        this.attachedItemStack = stack.func_77979_a(1);
    }

    public void onConvertToGrill(EntityPlayer player, ItemStack stack) {
        this.dumpNonExtraItems(player);
        this.attachedItemStack = stack.func_77979_a(1);
    }

    public void onRemoveAttachment(EntityPlayer player, ItemStack stack) {
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)this.attachedItemStack);
        this.attachedItemStack = ItemStack.field_190927_a;
    }

    public void addWaterToCookingPot() {
        this.cookingPotStage = CookingPotStage.WAITING;
        this.temperature = 0.0f;
    }

    @Nonnull
    public CookingPotStage getCookingPotStage() {
        return this.cookingPotStage;
    }

    @Override
    public int getFieldCount() {
        return 3;
    }

    @Override
    public void setField(int index, int value) {
        switch (index) {
            case 0: {
                this.temperature = value;
                break;
            }
            case 1: {
                this.cookingPotStage = CookingPotStage.valueOf(value);
                break;
            }
            case 2: {
                this.soupServings = value;
                break;
            }
            default: {
                TerraFirmaCraft.getLog().warn("Invalid Field ID {} in TEFirePit#setField", (Object)index);
            }
        }
    }

    @Override
    public int getField(int index) {
        switch (index) {
            case 0: {
                return (int)this.temperature;
            }
            case 1: {
                return this.cookingPotStage.ordinal();
            }
            case 2: {
                return this.soupServings;
            }
        }
        TerraFirmaCraft.getLog().warn("Invalid Field ID {} in TEFirePit#getField", (Object)index);
        return 0;
    }

    public void onAirIntake(int amount) {
        this.airTicks += amount;
        if (this.airTicks > 600) {
            this.airTicks = 600;
        }
    }

    public void onUseBowlOnCookingPot(EntityPlayer player, ItemStack stack) {
        if (this.soupServings > 0) {
            --this.soupServings;
            ItemStack soupStack = new ItemStack(this.getSoupItem());
            IFood soupFood = (IFood)soupStack.getCapability(CapabilityFood.CAPABILITY, null);
            if (soupFood instanceof ItemDynamicBowlFood.DynamicFoodHandler) {
                soupFood.setCreationDate(this.soupCreationDate);
                ((ItemDynamicBowlFood.DynamicFoodHandler)soupFood).initCreationDataAndBowl(stack.func_77979_a(1), this.soupContents);
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)soupStack);
            if (this.soupServings == 0) {
                this.cookingPotStage = CookingPotStage.EMPTY;
            }
        }
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack, EnumFacing side) {
        return slot == 3 || this.cookingPotStage != CookingPotStage.BOILING && this.cookingPotStage != CookingPotStage.FINISHED;
    }

    @Override
    public boolean canExtract(int slot, EnumFacing side) {
        return slot == 3 || this.cookingPotStage != CookingPotStage.BOILING && this.cookingPotStage != CookingPotStage.FINISHED;
    }

    private void updateCachedGrillRecipes() {
        for (int i = 7; i <= 11; ++i) {
            this.cachedGrillRecipes[i - 7] = HeatRecipe.get(this.inventory.getStackInSlot(i));
        }
    }

    private void dumpNonExtraItems(EntityPlayer player) {
        for (int i = 4; i < 6; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (!stack.func_190926_b()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack);
            }
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    private void cascadeFuelSlots() {
        int lowestAvailSlot = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (i > lowestAvailSlot) {
                this.inventory.setStackInSlot(lowestAvailSlot, stack.func_77946_l());
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
            ++lowestAvailSlot;
        }
        this.requiresSlotUpdate = false;
    }

    private void handleInputMelting(ItemStack stack) {
        IItemHeat cap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
        if (this.cachedRecipe != null && cap != null && this.cachedRecipe.isValidTemperature(cap.getTemperature())) {
            HeatRecipe recipe = this.cachedRecipe;
            FluidStack fluidStack = recipe.getOutputFluid(stack);
            float itemTemperature = cap.getTemperature();
            if (fluidStack != null) {
                IItemHeat heatHandler;
                int amountFilled;
                ItemStack output = this.inventory.getStackInSlot(5);
                IFluidHandler fluidHandler = (IFluidHandler)output.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                if (fluidHandler != null) {
                    amountFilled = fluidHandler.fill(fluidStack.copy(), true);
                    fluidStack.amount -= amountFilled;
                    heatHandler = (IItemHeat)output.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                    if (heatHandler != null) {
                        heatHandler.setTemperature(itemTemperature);
                    }
                }
                if (fluidStack.amount > 0 && (fluidHandler = (IFluidHandler)(output = this.inventory.getStackInSlot(6)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) != null && (amountFilled = fluidHandler.fill(fluidStack, true)) > 0 && (heatHandler = (IItemHeat)output.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null)) != null) {
                    heatHandler.setTemperature(itemTemperature);
                }
            }
            ItemStack inputStack = this.inventory.getStackInSlot(4);
            ItemStack outputStack = recipe.getOutputStack(inputStack);
            inputStack.func_190918_g(1);
            if (!outputStack.func_190926_b() && !(outputStack = this.mergeOutputStack(outputStack)).func_190926_b()) {
                this.leftover.add(outputStack);
            }
        }
    }

    private void handleGrillCooking(int slot, ItemStack stack, IItemHeat heat) {
        HeatRecipe recipe = this.cachedGrillRecipes[slot - 7];
        if (recipe != null && recipe.isValidTemperature(heat.getTemperature())) {
            ItemStack output = recipe.getOutputStack(stack);
            CapabilityFood.applyTrait(output, FoodTrait.WOOD_GRILLED);
            this.inventory.setStackInSlot(slot, output);
            this.markForSync();
        }
    }

    private ItemStack mergeOutputStack(ItemStack outputStack) {
        outputStack = this.inventory.insertItem(5, outputStack, false);
        this.inventory.setStackInSlot(5, CapabilityFood.mergeItemStacksIgnoreCreationDate(this.inventory.getStackInSlot(5), outputStack));
        outputStack = this.inventory.insertItem(6, outputStack, false);
        this.inventory.setStackInSlot(6, CapabilityFood.mergeItemStacksIgnoreCreationDate(this.inventory.getStackInSlot(6), outputStack));
        return outputStack;
    }

    private Item getSoupItem() {
        switch (this.soupNutrient) {
            case GRAIN: {
                return ItemFoodTFC.get(Food.SOUP_GRAIN);
            }
            case VEGETABLES: {
                return ItemFoodTFC.get(Food.SOUP_VEGETABLE);
            }
            case FRUIT: {
                return ItemFoodTFC.get(Food.SOUP_FRUIT);
            }
            case PROTEIN: {
                return ItemFoodTFC.get(Food.SOUP_MEAT);
            }
        }
        return ItemFoodTFC.get(Food.SOUP_DAIRY);
    }

    public static enum CookingPotStage {
        EMPTY,
        WAITING,
        BOILING,
        FINISHED;

        private static final CookingPotStage[] VALUES;

        public static CookingPotStage valueOf(int id) {
            return id >= 0 && id < VALUES.length ? VALUES[id] : EMPTY;
        }

        static {
            VALUES = CookingPotStage.values();
        }
    }
}

