/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.te;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.recipes.heat.HeatRecipe;
import net.dries007.tfc.api.util.IHeatConsumerBlock;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.te.ITileFields;
import net.dries007.tfc.objects.te.TETickableInventory;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.fuel.Fuel;
import net.dries007.tfc.util.fuel.FuelManager;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

@ParametersAreNonnullByDefault
public class TECharcoalForge
extends TETickableInventory
implements ICalendarTickable,
ITileFields {
    public static final int SLOT_FUEL_MIN = 0;
    public static final int SLOT_FUEL_MAX = 4;
    public static final int SLOT_INPUT_MIN = 5;
    public static final int SLOT_INPUT_MAX = 9;
    public static final int SLOT_EXTRA_MIN = 10;
    public static final int SLOT_EXTRA_MAX = 13;
    public static final int FIELD_TEMPERATURE = 0;
    private final HeatRecipe[] cachedRecipes = new HeatRecipe[5];
    private boolean requiresSlotUpdate = false;
    private float temperature = 0.0f;
    private int burnTicks = 0;
    private float burnTemperature = 0.0f;
    private int airTicks = 0;
    private long lastPlayerTick = CalendarTFC.PLAYER_TIME.getTicks();

    public TECharcoalForge() {
        super(14);
        Arrays.fill(this.cachedRecipes, null);
    }

    public void onAirIntake(int amount) {
        this.airTicks += amount;
        if (this.airTicks > 600) {
            this.airTicks = 600;
        }
    }

    public void onRainDrop() {
        this.burnTicks -= ConfigTFC.Devices.CHARCOAL_FORGE.rainTicks;
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.8f, 0.8f + Constants.RNG.nextFloat() * 0.4f);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.checkForCalendarUpdate();
        if (!this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (((Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT)).booleanValue()) {
                if (this.burnTicks > 0) {
                    this.burnTicks -= this.airTicks > 0 ? 2 : 1;
                }
                if (this.burnTicks <= 0) {
                    ItemStack stack = this.inventory.getStackInSlot(0);
                    if (stack.func_190926_b()) {
                        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(false)));
                        this.burnTicks = 0;
                        this.burnTemperature = 0.0f;
                    } else {
                        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                        this.requiresSlotUpdate = true;
                        Fuel fuel = FuelManager.getFuel(stack);
                        this.burnTicks = fuel.getAmount();
                        this.burnTemperature = fuel.getTemperature();
                    }
                }
            } else if (this.burnTemperature > 0.0f) {
                this.burnTemperature = 0.0f;
                this.burnTicks = 0;
            }
            this.airTicks = this.airTicks > 0 ? --this.airTicks : 0;
            if (this.temperature > 0.0f || this.burnTemperature > 0.0f) {
                Block blockUp;
                float targetTemperature = this.burnTemperature + (float)this.airTicks;
                if (this.temperature != targetTemperature) {
                    float delta = (float)ConfigTFC.Devices.TEMPERATURE.heatingModifier;
                    this.temperature = CapabilityItemHeat.adjustTempTowards(this.temperature, targetTemperature, delta * (float)(this.airTicks > 0 ? 2 : 1), delta * (this.airTicks > 0 ? 0.5f : 1.0f));
                }
                if ((blockUp = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c()) instanceof IHeatConsumerBlock) {
                    ((IHeatConsumerBlock)blockUp).acceptHeat(this.field_145850_b, this.field_174879_c.func_177984_a(), this.temperature);
                }
                for (int i = 5; i <= 9; ++i) {
                    ItemStack stack = this.inventory.getStackInSlot(i);
                    IItemHeat cap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                    if (cap == null) continue;
                    float itemTemp = cap.getTemperature();
                    if (this.temperature > itemTemp) {
                        CapabilityItemHeat.addTemp(cap);
                    }
                    this.handleInputMelting(stack, i);
                }
            }
            if (this.requiresSlotUpdate) {
                this.cascadeFuelSlots();
            }
            this.func_70296_d();
        }
    }

    @Override
    public void onCalendarUpdate(long deltaPlayerTicks) {
        int i;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!((Boolean)state.func_177229_b((IProperty)ILightableBlock.LIT)).booleanValue()) {
            return;
        }
        if ((long)this.burnTicks > deltaPlayerTicks) {
            this.burnTicks = (int)((long)this.burnTicks - deltaPlayerTicks);
            return;
        }
        deltaPlayerTicks -= (long)this.burnTicks;
        this.burnTicks = 0;
        this.requiresSlotUpdate = true;
        for (i = 0; i <= 4; ++i) {
            ItemStack fuelStack = this.inventory.getStackInSlot(i);
            Fuel fuel = FuelManager.getFuel(fuelStack);
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            if ((long)fuel.getAmount() > deltaPlayerTicks) {
                this.burnTicks = (int)((long)fuel.getAmount() - deltaPlayerTicks);
                this.burnTemperature = fuel.getTemperature();
                return;
            }
            deltaPlayerTicks -= (long)fuel.getAmount();
            this.burnTicks = 0;
        }
        if (deltaPlayerTicks > 0L) {
            this.burnTemperature = 0.0f;
            this.temperature = 0.0f;
            for (i = 5; i <= 9; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                IItemHeat cap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                if (cap == null) continue;
                cap.setTemperature(0.0f);
            }
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public long getLastUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    public void setLastUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    public void onCreate() {
        this.burnTicks = 200;
        this.burnTemperature = 500.0f;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.requiresSlotUpdate = true;
        this.updateCachedRecipes();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.temperature = nbt.func_74760_g("temperature");
        this.burnTicks = nbt.func_74762_e("burnTicks");
        this.airTicks = nbt.func_74762_e("airTicks");
        this.burnTemperature = nbt.func_74760_g("burnTemperature");
        this.lastPlayerTick = nbt.func_74763_f("lastPlayerTick");
        super.func_145839_a(nbt);
        this.updateCachedRecipes();
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74776_a("temperature", this.temperature);
        nbt.func_74768_a("burnTicks", this.burnTicks);
        nbt.func_74768_a("airTicks", this.airTicks);
        nbt.func_74776_a("burnTemperature", this.burnTemperature);
        nbt.func_74772_a("lastPlayerTick", this.lastPlayerTick);
        return super.func_189515_b(nbt);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot <= 4) {
            return FuelManager.isItemForgeFuel(stack);
        }
        if (slot <= 9) {
            return stack.hasCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
        }
        return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && stack.hasCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
    }

    @Override
    public int getFieldCount() {
        return 1;
    }

    @Override
    public void setField(int index, int value) {
        if (index == 0) {
            this.temperature = value;
        } else {
            TerraFirmaCraft.getLog().warn("Invalid field ID {} in TECharcoalForge#setField", (Object)index);
        }
    }

    @Override
    public int getField(int index) {
        if (index == 0) {
            return (int)this.temperature;
        }
        TerraFirmaCraft.getLog().warn("Invalid field ID {} in TECharcoalForge#getField", (Object)index);
        return 0;
    }

    private void handleInputMelting(ItemStack stack, int startIndex) {
        HeatRecipe recipe = this.cachedRecipes[startIndex - 5];
        IItemHeat cap = (IItemHeat)stack.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
        if (recipe != null && cap != null && recipe.isValidTemperature(cap.getTemperature())) {
            FluidStack fluidStack = recipe.getOutputFluid(stack);
            ItemStack outputStack = recipe.getOutputStack(stack);
            float itemTemperature = cap.getTemperature();
            if (fluidStack != null) {
                for (int i = 10; i <= 13 && fluidStack.amount > 0; ++i) {
                    int amountFilled;
                    ItemStack output = this.inventory.getStackInSlot(i);
                    IFluidHandler fluidHandler = (IFluidHandler)output.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                    if (fluidHandler == null || (amountFilled = fluidHandler.fill(fluidStack.copy(), true)) <= 0) continue;
                    fluidStack.amount -= amountFilled;
                    IItemHeat heatHandler = (IItemHeat)output.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                    if (heatHandler == null) continue;
                    heatHandler.setTemperature(itemTemperature);
                }
            }
            CapabilityFood.applyTrait(outputStack, FoodTrait.CHARCOAL_GRILLED);
            this.inventory.setStackInSlot(startIndex, outputStack);
        }
    }

    private void cascadeFuelSlots() {
        int lowestAvailSlot = 0;
        for (int i = 0; i <= 4; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (i > lowestAvailSlot) {
                this.inventory.setStackInSlot(lowestAvailSlot, stack.func_77946_l());
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
            ++lowestAvailSlot;
        }
        this.requiresSlotUpdate = false;
    }

    private void updateCachedRecipes() {
        for (int i = 5; i <= 9; ++i) {
            this.cachedRecipes[i - 5] = null;
            ItemStack inputStack = this.inventory.getStackInSlot(i);
            if (inputStack.func_190926_b()) continue;
            this.cachedRecipes[i - 5] = HeatRecipe.get(inputStack);
        }
    }
}

