/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.recipes.ingredients;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidIngredient
extends Ingredient {
    private final FluidStack fluid;

    private static ItemStack[] getValidBuckets(FluidStack fluid) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        ItemStack woodenBucket = new ItemStack((Item)ItemsTFC.WOODEN_BUCKET);
        IFluidHandler bucketCap = (IFluidHandler)woodenBucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (bucketCap != null && bucketCap.fill(fluid, true) >= 1000) {
            output.add(woodenBucket);
        }
        output.add(FluidUtil.getFilledBucket((FluidStack)fluid));
        return output.toArray(new ItemStack[0]);
    }

    public FluidIngredient(String fluidName) {
        super(FluidIngredient.getValidBuckets(new FluidStack(FluidRegistry.getFluid((String)fluidName), 1000)));
        this.fluid = FluidRegistry.getFluidStack((String)fluidName, (int)1000);
    }

    public boolean apply(@Nullable ItemStack input) {
        IFluidHandlerItem handler;
        if (input == null || input.func_190926_b()) {
            return false;
        }
        ItemStack stack = input.func_77946_l();
        stack.func_190920_e(1);
        IFluidHandlerItem iFluidHandlerItem = handler = input.func_190916_E() > 1 ? FluidUtil.getFluidHandler((ItemStack)stack) : FluidUtil.getFluidHandler((ItemStack)input);
        if (handler == null) {
            return false;
        }
        return this.fluid.isFluidStackIdentical(handler.drain(1000, false));
    }

    public boolean isSimple() {
        return false;
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            String fluidName = JsonUtils.func_151219_a((JsonObject)json, (String)"fluid", (String)"");
            return new FluidIngredient(fluidName);
        }
    }
}

