/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.objects.recipes.RecipeUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@ParametersAreNonnullByDefault
public class ShapelessFluidFoodRecipe
extends ShapelessOreRecipe {
    public ShapelessFluidFoodRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result) {
        super(group, input, result);
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ret.size(); ++i) {
            IFluidHandlerItem handler;
            ItemStack itemStack = inv.func_70301_a(i);
            ItemStack stack = itemStack.func_77946_l();
            stack.func_190920_e(1);
            IFluidHandlerItem iFluidHandlerItem = handler = itemStack.func_190916_E() > 1 ? FluidUtil.getFluidHandler((ItemStack)stack) : FluidUtil.getFluidHandler((ItemStack)itemStack);
            if (handler == null) {
                ret.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemStack));
                continue;
            }
            handler.drain(1000, true);
            ItemStack updatedItem = handler.getContainer().func_77946_l();
            ret.set(i, (Object)updatedItem);
        }
        return ret;
    }

    public boolean func_192399_d() {
        return true;
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack out = this.output.func_77946_l();
        long smallestRottenDate = -1L;
        ItemStack foodStack = null;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            IFood foodCap;
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b() || (foodCap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null)) == null || smallestRottenDate != -1L && smallestRottenDate <= foodCap.getRottenDate()) continue;
            smallestRottenDate = foodCap.getRottenDate();
            foodStack = stack;
        }
        return foodStack != null ? CapabilityFood.updateFoodFromPrevious(foodStack, out) : ItemStack.field_190927_a;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = RecipeUtils.parseShapeless(context, json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            return new ShapelessFluidFoodRecipe(group.isEmpty() ? null : new ResourceLocation(group), ingredients, result);
        }
    }
}

