/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.dries007.tfc.objects.recipes.RecipeUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessDamageRecipe
extends ShapelessOreRecipe {
    private final int damage;

    public ShapelessDamageRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result, int damage) {
        super(group, input, result);
        this.isSimple = false;
        this.damage = damage;
    }

    public NonNullList<ItemStack> getRemainingItemsDamaged(InventoryCrafting inv) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            if (!itemstack.func_190926_b() && itemstack.func_77973_b().func_77645_m()) {
                remainingItems.set(i, (Object)this.damageStack(itemstack));
                continue;
            }
            remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return remainingItems;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventoryCrafting) {
        return this.getRemainingItemsDamaged(inventoryCrafting);
    }

    @Nonnull
    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    private ItemStack damageStack(ItemStack stack) {
        ItemStack damagedStack = stack.func_77946_l();
        damagedStack.func_77972_a(this.damage, (EntityLivingBase)ForgeHooks.getCraftingPlayer());
        return damagedStack;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = RecipeUtils.parseShapeless(context, json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            int damage = JsonUtils.func_151204_g((JsonObject)json, (String)"damage") ? JsonUtils.func_151203_m((JsonObject)json, (String)"damage") : 1;
            return new ShapelessDamageRecipe(group.isEmpty() ? null : new ResourceLocation(group), ingredients, result, damage);
        }
    }
}

