/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.recipes;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodTrait;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.objects.recipes.RecipeUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
public class SaltingRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final NonNullList<Ingredient> input;
    private final ResourceLocation group;

    private SaltingRecipe(@Nullable ResourceLocation group, NonNullList<Ingredient> input) {
        this.group = group;
        this.input = input;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            IFood food;
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || (food = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null)) != null && (food.isRotten() || food.getTraits().contains(FoodTrait.SALTED))) continue;
            items.add(stack);
        }
        return items.size() == this.input.size() && RecipeMatcher.findMatches(items, this.input) != null;
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack result = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i).func_77946_l();
            stack.func_190920_e(1);
            IFood food = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
            if (food == null) continue;
            CapabilityFood.applyTrait(food, FoodTrait.SALTED);
            result = stack;
            break;
        }
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.input.size();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.input;
    }

    public boolean func_192399_d() {
        return true;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> ingredients = RecipeUtils.parseShapeless(context, json);
            return new SaltingRecipe(group.isEmpty() ? null : new ResourceLocation(group), ingredients);
        }
    }
}

