/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.wood;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.blocks.wood.BlockDoorTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemDoorTFC
extends ItemDoor
implements IItemSize {
    private static final Map<Tree, ItemDoorTFC> MAP = new HashMap<Tree, ItemDoorTFC>();
    public final Tree wood;

    public static ItemDoorTFC get(Tree wood) {
        return MAP.get((Object)wood);
    }

    public ItemDoorTFC(BlockDoorTFC block) {
        super((Block)block);
        if (MAP.put(block.wood, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.wood = block.wood;
        OreDictionaryHelper.register((Item)this, "door", "wood");
        OreDictionaryHelper.register((Item)this, "door", "wood", this.wood.getRegistryName().func_110623_a());
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.VERY_LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.HEAVY;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getStackSize(stack);
    }
}

