/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.rock;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.damage.DamageType;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.api.util.IRockObject;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemRockKnife
extends ItemTool
implements IItemSize,
IRockObject {
    private static final Map<RockCategory, ItemRockKnife> MAP = new HashMap<RockCategory, ItemRockKnife>();
    public final RockCategory category;

    public static ItemRockKnife get(RockCategory category) {
        return MAP.get((Object)category);
    }

    public ItemRockKnife(RockCategory category) {
        super(-0.46f * category.getToolMaterial().func_78000_c(), -1.5f, category.getToolMaterial(), (Set)ImmutableSet.of());
        this.category = category;
        if (MAP.put(category, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.setHarvestLevel("knife", category.getToolMaterial().func_77996_d());
        OreDictionaryHelper.registerDamageType((Item)this, DamageType.PIERCING);
        OreDictionaryHelper.register((Item)this, "knife");
        OreDictionaryHelper.register((Item)this, "knife", "stone");
        OreDictionaryHelper.register((Item)this, new Object[]{"knife", "stone", category});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Rock type: " + OreDictionaryHelper.toString(new Object[]{this.category}));
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.NORMAL;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.MEDIUM;
    }

    @Override
    public boolean canStack(ItemStack stack) {
        return false;
    }

    @Override
    @Nullable
    public Rock getRock(ItemStack stack) {
        return null;
    }

    @Override
    @Nonnull
    public RockCategory getRockCategory(ItemStack stack) {
        return this.category;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (!worldIn.field_72995_K) {
            stack.func_77972_a(1, entityLiving);
        }
        return true;
    }
}

