/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.rock;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.damage.DamageType;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.api.util.IRockObject;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.entity.projectile.EntityThrownJavelin;
import net.dries007.tfc.objects.items.ItemQuiver;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemRockJavelin
extends ItemTool
implements IItemSize,
IRockObject {
    private static final Map<RockCategory, ItemRockJavelin> MAP = new HashMap<RockCategory, ItemRockJavelin>();
    public final RockCategory category;

    public static ItemRockJavelin get(RockCategory category) {
        return MAP.get((Object)category);
    }

    public ItemRockJavelin(RockCategory category) {
        super(-0.3f * category.getToolMaterial().func_78000_c(), -1.8f, category.getToolMaterial(), (Set)ImmutableSet.of());
        this.category = category;
        if (MAP.put(category, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_77656_e((int)((double)category.getToolMaterial().func_77997_a() * 0.1));
        OreDictionaryHelper.registerDamageType((Item)this, DamageType.PIERCING);
        OreDictionaryHelper.register((Item)this, "javelin");
        OreDictionaryHelper.register((Item)this, "javelin", "stone");
        OreDictionaryHelper.register((Item)this, new Object[]{"javelin", "stone", category});
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.MEDIUM;
    }

    @Override
    public boolean canStack(ItemStack stack) {
        return false;
    }

    @Override
    @Nullable
    public Rock getRock(ItemStack stack) {
        return null;
    }

    @Override
    @Nonnull
    public RockCategory getRockCategory(ItemStack stack) {
        return this.category;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            int charge = this.func_77626_a(stack) - timeLeft;
            if (charge > 5) {
                float f = ItemBow.func_185059_b((int)charge);
                if (!worldIn.field_72995_K) {
                    EntityThrownJavelin javelin = new EntityThrownJavelin(worldIn, (EntityLivingBase)player);
                    javelin.func_70239_b(2.5f * this.field_77865_bY);
                    javelin.setWeapon(stack);
                    javelin.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 1.5f, 0.5f);
                    worldIn.func_72838_d((Entity)javelin);
                    worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, TFCSounds.ITEM_THROW, SoundCategory.PLAYERS, 1.0f, 1.0f / (Constants.RNG.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                }
                player.field_71071_by.func_184437_d(stack);
                player.func_71029_a(StatList.func_188057_b((Item)this));
                ItemQuiver.replenishJavelin(player.field_71071_by);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Rock type: " + OreDictionaryHelper.toString(new Object[]{this.category}));
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }
}

