/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.rock;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.api.util.IRockObject;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
public class ItemBrickTFC
extends ItemTFC
implements IRockObject {
    private static final Map<Rock, ItemBrickTFC> MAP = new HashMap<Rock, ItemBrickTFC>();
    private final Rock rock;

    public static ItemBrickTFC get(Rock ore) {
        return MAP.get((Object)ore);
    }

    public static ItemStack get(Rock ore, int amount) {
        return new ItemStack((Item)MAP.get((Object)ore), amount);
    }

    public ItemBrickTFC(Rock rock) {
        this.rock = rock;
        if (MAP.put(rock, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_77656_e(0);
        OreDictionaryHelper.register(this, "brick");
        OreDictionaryHelper.register(this, new Object[]{"brick", rock.getRockCategory()});
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.SMALL;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.LIGHT;
    }

    @Override
    @Nonnull
    public Rock getRock(ItemStack stack) {
        return this.rock;
    }

    @Override
    @Nonnull
    public RockCategory getRockCategory(ItemStack stack) {
        return this.rock.getRockCategory();
    }
}

