/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.metal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.damage.DamageType;
import net.dries007.tfc.api.capability.forge.ForgeableHeatableHandler;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemMetalSword
extends ItemSword
implements IMetalItem,
IItemSize {
    private static final Map<Metal, ItemMetalSword> TABLE = new HashMap<Metal, ItemMetalSword>();
    public final Item.ToolMaterial field_150933_b;
    private final Metal metal;
    private final float attackDamage;

    public static ItemMetalSword get(Metal metal) {
        return TABLE.get((Object)metal);
    }

    public ItemMetalSword(Metal metal) {
        super(metal.getToolMetal());
        this.metal = metal;
        if (metal.getToolMetal() == null) {
            throw new IllegalArgumentException("You can't make weapons out of non tool metals.");
        }
        this.field_150933_b = metal.getToolMetal();
        if (!TABLE.containsKey((Object)metal)) {
            TABLE.put(metal, this);
        }
        this.func_77625_d(1);
        this.func_77656_e(this.field_150933_b.func_77997_a());
        this.attackDamage = this.field_150933_b.func_78000_c();
        OreDictionaryHelper.register((Item)this, new Object[]{Metal.ItemType.SWORD});
        OreDictionaryHelper.registerDamageType((Item)this, DamageType.SLASHING);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    @Override
    @Nullable
    public Metal getMetal(ItemStack stack) {
        return this.metal;
    }

    @Override
    public int getSmeltAmount(ItemStack stack) {
        if (!this.func_77645_m() || !stack.func_77951_h()) {
            return Metal.ItemType.SWORD.getSmeltAmount();
        }
        double d = (double)(stack.func_77958_k() - stack.func_77952_i()) / (double)stack.func_77958_k() - 0.1;
        return d < 0.0 ? 0 : MathHelper.func_76128_c((double)((double)Metal.ItemType.SWORD.getSmeltAmount() * d));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ForgeableHeatableHandler(nbt, this.metal.getSpecificHeat(), this.metal.getMeltTemp());
    }

    @Nonnull
    public IRarity getForgeRarity(@Nonnull ItemStack stack) {
        switch (this.metal.getTier()) {
            case TIER_I: 
            case TIER_II: {
                return EnumRarity.COMMON;
            }
            case TIER_III: {
                return EnumRarity.UNCOMMON;
            }
            case TIER_IV: {
                return EnumRarity.RARE;
            }
            case TIER_V: {
                return EnumRarity.EPIC;
            }
        }
        return super.getForgeRarity(stack);
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.MEDIUM;
    }
}

