/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.metal;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.fluids.capability.FluidWhitelistHandler;
import net.dries007.tfc.objects.items.metal.ItemMetal;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemMetalBucket
extends ItemMetal {
    private static final int CAPACITY = 1000;

    public ItemMetalBucket(Metal metal, Metal.ItemType type) {
        super(metal, type);
        this.func_77627_a(true);
        this.func_77642_a(this);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DispenseFluidContainer.getInstance());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, @Nullable EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && !stack.func_190926_b()) {
            IFluidHandler bucketCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            RayTraceResult rayTrace = this.func_77621_a(worldIn, playerIn, true);
            if (rayTrace != null && bucketCap != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos pos = rayTrace.func_178782_a();
                if (bucketCap.drain(1000, false) == null) {
                    ItemStack single = stack.func_77946_l();
                    single.func_190920_e(1);
                    FluidActionResult result = FluidUtil.tryPickUpFluid((ItemStack)single, (EntityPlayer)playerIn, (World)worldIn, (BlockPos)pos, (EnumFacing)rayTrace.field_178784_b);
                    if (result.isSuccess()) {
                        stack.func_190918_g(1);
                        if (stack.func_190926_b()) {
                            return new ActionResult(EnumActionResult.SUCCESS, (Object)result.getResult());
                        }
                        if (!playerIn.func_184812_l_()) {
                            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)result.getResult());
                        }
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                    }
                } else {
                    IBlockState stateAt = worldIn.func_180495_p(pos);
                    if (!stateAt.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && stateAt.func_185904_a().func_76220_a()) {
                        pos = pos.func_177972_a(rayTrace.field_178784_b);
                    }
                    if ((stateAt = worldIn.func_180495_p(pos)).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) || !stateAt.func_185904_a().func_76220_a()) {
                        FluidStack fluidStack;
                        if (!stateAt.func_185904_a().func_76224_d()) {
                            worldIn.func_175655_b(pos, true);
                        }
                        if ((fluidStack = bucketCap.drain(1000, !playerIn.func_184812_l_())) != null) {
                            Fluid fluid = fluidStack.getFluid();
                            if (fluid.getBlock() instanceof BlockFluidBase) {
                                worldIn.func_175656_a(pos, fluid.getBlock().func_176223_P());
                            } else if (fluid.getBlock() instanceof BlockLiquid) {
                                try {
                                    BlockDynamicLiquid flowingBlock = BlockStaticLiquid.func_176361_a((Material)fluid.getBlock().func_176223_P().func_185904_a());
                                    worldIn.func_175656_a(pos, flowingBlock.func_176223_P());
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    // empty catch block
                                }
                            }
                        }
                        worldIn.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                    }
                }
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        FluidStack fluidStack;
        IFluidHandler bucketCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (bucketCap != null && (fluidStack = bucketCap.drain(1000, false)) != null) {
            String fluidName = fluidStack.getLocalizedName();
            return new TextComponentTranslation(this.func_77658_a() + ".filled.name", new Object[]{fluidName}).func_150254_d();
        }
        return super.func_77653_i(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            for (Fluid fluid : this.getValidFluids()) {
                ItemStack stack = new ItemStack((Item)this);
                IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (cap != null) {
                    cap.fill(new FluidStack(fluid, 1000), true);
                }
                items.add((Object)stack);
            }
        }
    }

    public Set<Fluid> getValidFluids() {
        String[] fluidNames = new String[]{};
        if (((Object)((Object)this.metal)).equals((Object)Metal.BLUE_STEEL)) {
            fluidNames = ConfigTFC.General.MISC.blueSteelBucketWhitelist;
        } else if (((Object)((Object)this.metal)).equals((Object)Metal.RED_STEEL)) {
            fluidNames = ConfigTFC.General.MISC.redSteelBucketWhitelist;
        }
        HashSet<Fluid> validFluids = new HashSet<Fluid>();
        for (String fluidName : fluidNames) {
            validFluids.add(FluidRegistry.getFluid((String)fluidName));
        }
        return validFluids;
    }

    @Override
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidWhitelistHandler(stack, 1000, this.getValidFluids());
    }
}

