/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.food;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodHandler;
import net.dries007.tfc.api.capability.food.FoodHeatHandler;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.api.capability.food.IItemFoodTFC;
import net.dries007.tfc.api.capability.size.IItemSize;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.agriculture.Food;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

@ParametersAreNonnullByDefault
public class ItemFoodTFC
extends ItemFood
implements IItemSize,
IItemFoodTFC {
    private static final Map<Food, ItemFoodTFC> MAP = new HashMap<Food, ItemFoodTFC>();
    protected final Food food;

    public static ItemFoodTFC get(Food food) {
        return MAP.get((Object)food);
    }

    public static ItemStack get(Food food, int amount) {
        return new ItemStack((Item)MAP.get((Object)food), amount);
    }

    public ItemFoodTFC(@Nonnull Food food) {
        super(0, 0.0f, food.getCategory() == Food.Category.MEAT || food.getCategory() == Food.Category.COOKED_MEAT);
        this.food = food;
        if (MAP.put(food, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        OreDictionaryHelper.register((Item)this, new Object[]{"category", food.getCategory()});
        if (food.getOreDictNames() != null) {
            for (String name : food.getOreDictNames()) {
                OreDictionaryHelper.register((Item)this, name);
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            IFood cap = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
            if (cap != null) {
                cap.setNonDecaying();
            }
            items.add((Object)stack);
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getStackSize(stack);
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.SMALL;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.VERY_LIGHT;
    }

    @Override
    public ICapabilityProvider getCustomFoodHandler() {
        return this.food.isHeatable() ? new FoodHeatHandler(null, this.food) : new FoodHandler(null, this.food);
    }
}

