/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.food;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.food.CapabilityFood;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.FoodHandler;
import net.dries007.tfc.api.capability.food.IFood;
import net.dries007.tfc.objects.items.food.ItemFoodTFC;
import net.dries007.tfc.util.agriculture.Food;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
public class ItemDynamicBowlFood
extends ItemFoodTFC {
    public ItemDynamicBowlFood(Food food) {
        super(food);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new DynamicFoodHandler(nbt, this.food.getData());
    }

    @Nonnull
    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        IFood food = (IFood)stack.getCapability(CapabilityFood.CAPABILITY, null);
        if (food instanceof DynamicFoodHandler) {
            ItemStack bowlStack = ((DynamicFoodHandler)food).getBowlStack();
            if (entityLiving instanceof EntityPlayer) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)entityLiving), (ItemStack)bowlStack);
            }
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public static class DynamicFoodHandler
    extends FoodHandler {
        private ItemStack bowlStack = ItemStack.field_190927_a;

        public DynamicFoodHandler(@Nullable NBTTagCompound nbt, FoodData data) {
            super(nbt, data);
        }

        public void initCreationDataAndBowl(ItemStack bowlStack, FoodData data) {
            this.bowlStack = bowlStack;
            this.data = data;
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound nbt = super.serializeNBT();
            nbt.func_74782_a("bowl", (NBTBase)this.bowlStack.serializeNBT());
            return nbt;
        }

        @Override
        public void deserializeNBT(@Nullable NBTTagCompound nbt) {
            super.deserializeNBT(nbt);
            if (nbt != null) {
                this.bowlStack = new ItemStack(nbt.func_74775_l("bowl"));
            }
        }

        @Override
        protected boolean isDynamic() {
            return true;
        }

        @Nonnull
        public ItemStack getBowlStack() {
            return this.bowlStack.func_77946_l();
        }
    }
}

