/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.ceramics;

import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.fluids.capability.FluidWhitelistHandler;
import net.dries007.tfc.objects.fluids.properties.DrinkableProperty;
import net.dries007.tfc.objects.fluids.properties.FluidWrapper;
import net.dries007.tfc.objects.items.ceramics.ItemPottery;
import net.dries007.tfc.util.FluidTransferHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemJug
extends ItemPottery {
    private static final int CAPACITY = 100;

    public ItemJug() {
        this.func_77627_a(true);
        this.func_77642_a(this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        IFluidHandler jugCap;
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && (jugCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) != null) {
            if (jugCap.drain(100, false) != null) {
                if (!world.field_72995_K && ConfigTFC.Devices.JUG.dumpWaterOnShiftRightClick && player.func_70093_af()) {
                    jugCap.drain(100, true);
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v, TFCSounds.JUG_FILL, SoundCategory.BLOCKS, 1.0f, 0.5f);
                    Vec3d look = player.func_70040_Z();
                    ((WorldServer)world).func_175739_a(EnumParticleTypes.WATER_DROP, player.field_70165_t + look.field_72450_a, player.field_70163_u + 0.3 + world.field_73012_v.nextDouble(), player.field_70161_v + look.field_72449_c, 42, 0.1, 0.4, 0.2, 0.0, new int[0]);
                } else {
                    player.func_184598_c(hand);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            RayTraceResult rayTrace = this.func_77621_a(world, player, true);
            if (!world.field_72995_K && jugCap.drain(100, false) == null && rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) {
                ItemStack single = stack.func_77946_l();
                single.func_190920_e(1);
                FluidActionResult result = FluidTransferHelper.tryPickUpFluidGreedy(single, player, world, rayTrace.func_178782_a(), rayTrace.field_178784_b, 1000, false);
                if (result.isSuccess()) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)result.getResult());
                    }
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)result.getResult());
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
            } else {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), TFCSounds.JUG_BLOW, SoundCategory.PLAYERS, 1.0f, 0.8f + (float)(player.func_70040_Z().field_72448_b / 2.0));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        IFluidHandler jugCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (jugCap != null) {
            DrinkableProperty drinkable;
            FluidStack fluidConsumed = jugCap.drain(100, true);
            if (fluidConsumed != null && entityLiving instanceof EntityPlayer && (drinkable = FluidsTFC.getWrapper(fluidConsumed.getFluid()).get(DrinkableProperty.DRINKABLE)) != null) {
                drinkable.onDrink((EntityPlayer)entityLiving);
            }
            if ((double)Constants.RNG.nextFloat() < 0.02) {
                stack.func_190918_g(1);
                worldIn.func_184133_a(null, entityLiving.func_180425_c(), TFCSounds.CERAMIC_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        return stack;
    }

    @Nonnull
    public EnumAction func_77661_b(@Nonnull ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        FluidStack fluidStack;
        IFluidHandler bucketCap = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (bucketCap != null && (fluidStack = bucketCap.drain(100, false)) != null) {
            String fluidname = fluidStack.getLocalizedName();
            return new TextComponentTranslation("item.tfc.ceramics.fired.jug.filled", new Object[]{fluidname}).func_150254_d();
        }
        return super.func_77653_i(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            for (FluidWrapper wrapper : FluidsTFC.getAllWrappers()) {
                if (wrapper.get(DrinkableProperty.DRINKABLE) == null) continue;
                ItemStack stack = new ItemStack((Item)this);
                IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (cap != null) {
                    cap.fill(new FluidStack(wrapper.get(), 100), true);
                }
                items.add((Object)stack);
            }
        }
    }

    @Override
    public boolean canStack(ItemStack stack) {
        return false;
    }

    @Override
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidWhitelistHandler(stack, 100, FluidsTFC.getAllWrappers().stream().filter(x -> x.get(DrinkableProperty.DRINKABLE) != null).map(FluidWrapper::get).collect(Collectors.toSet()));
    }
}

