/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.api.types.RockCategory;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.CreativeTabsTFC;
import net.dries007.tfc.objects.Gem;
import net.dries007.tfc.objects.Powder;
import net.dries007.tfc.objects.blocks.BlockSlabTFC;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.wood.BlockDoorTFC;
import net.dries007.tfc.objects.blocks.wood.BlockLogTFC;
import net.dries007.tfc.objects.items.ItemAnimalHide;
import net.dries007.tfc.objects.items.ItemBloom;
import net.dries007.tfc.objects.items.ItemCraftingTool;
import net.dries007.tfc.objects.items.ItemDebug;
import net.dries007.tfc.objects.items.ItemFireStarter;
import net.dries007.tfc.objects.items.ItemGem;
import net.dries007.tfc.objects.items.ItemGlassBottleTFC;
import net.dries007.tfc.objects.items.ItemGoldPan;
import net.dries007.tfc.objects.items.ItemMisc;
import net.dries007.tfc.objects.items.ItemPowder;
import net.dries007.tfc.objects.items.ItemQuiver;
import net.dries007.tfc.objects.items.ItemSeedsTFC;
import net.dries007.tfc.objects.items.ItemSlabTFC;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.objects.items.ceramics.ItemJug;
import net.dries007.tfc.objects.items.ceramics.ItemMold;
import net.dries007.tfc.objects.items.ceramics.ItemPottery;
import net.dries007.tfc.objects.items.ceramics.ItemSmallVessel;
import net.dries007.tfc.objects.items.ceramics.ItemUnfiredLargeVessel;
import net.dries007.tfc.objects.items.ceramics.ItemUnfiredMold;
import net.dries007.tfc.objects.items.ceramics.ItemUnfiredSmallVessel;
import net.dries007.tfc.objects.items.food.ItemDynamicBowlFood;
import net.dries007.tfc.objects.items.food.ItemFoodTFC;
import net.dries007.tfc.objects.items.food.ItemSandwich;
import net.dries007.tfc.objects.items.itemblock.ItemBlockTFC;
import net.dries007.tfc.objects.items.itemblock.ItemBlockTorch;
import net.dries007.tfc.objects.items.metal.ItemMetal;
import net.dries007.tfc.objects.items.metal.ItemMetalBucket;
import net.dries007.tfc.objects.items.metal.ItemOreTFC;
import net.dries007.tfc.objects.items.metal.ItemSmallOre;
import net.dries007.tfc.objects.items.rock.ItemBrickTFC;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.dries007.tfc.objects.items.rock.ItemRockToolHead;
import net.dries007.tfc.objects.items.wood.ItemBoatTFC;
import net.dries007.tfc.objects.items.wood.ItemDoorTFC;
import net.dries007.tfc.objects.items.wood.ItemLumberTFC;
import net.dries007.tfc.objects.items.wood.ItemWoodenBucket;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.agriculture.Crop;
import net.dries007.tfc.util.agriculture.Food;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSnow;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="tfc")
@GameRegistry.ObjectHolder(value="tfc")
public final class ItemsTFC {
    public static final ItemGoldPan GOLDPAN = (ItemGoldPan)Helpers.getNull();
    public static final ItemMisc STRAW = (ItemMisc)Helpers.getNull();
    public static final Item HANDSTONE = (Item)Helpers.getNull();
    public static final Item WROUGHT_IRON_GRILL = (Item)Helpers.getNull();
    public static final Item GLUE = (Item)Helpers.getNull();
    public static final Item BRASS_MECHANISMS = (Item)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="crop/product/jute")
    public static final ItemMisc JUTE = (ItemMisc)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="crop/product/jute_fiber")
    public static final ItemMisc JUTE_FIBER = (ItemMisc)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="crop/product/burlap_cloth")
    public static final ItemMisc BURLAP_CLOTH = (ItemMisc)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="animal/product/wool")
    public static final ItemMisc WOOL = (ItemMisc)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="animal/product/wool_yarn")
    public static final ItemMisc WOOL_YARN = (ItemMisc)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="animal/product/wool_cloth")
    public static final ItemMisc WOOL_CLOTH = (ItemMisc)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="animal/product/silk_cloth")
    public static final ItemMisc SILK_CLOTH = (ItemMisc)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/unfired/fire_brick")
    public static final ItemPottery UNFIRED_FIRE_BRICK = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/fired/fire_brick")
    public static final ItemPottery FIRED_FIRE_BRICK = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/unfired/vessel")
    public static final ItemPottery UNFIRED_VESSEL = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/fired/vessel")
    public static final ItemPottery FIRED_VESSEL = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/unfired/vessel_glazed")
    public static final ItemPottery UNFIRED_VESSEL_GLAZED = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/fired/vessel_glazed")
    public static final ItemPottery FIRED_VESSEL_GLAZED = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/unfired/jug")
    public static final ItemPottery UNFIRED_JUG = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/fired/jug")
    public static final ItemPottery FIRED_JUG = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/unfired/pot")
    public static final ItemPottery UNFIRED_POT = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/fired/pot")
    public static final ItemPottery FIRED_POT = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/unfired/bowl")
    public static final ItemPottery UNFIRED_BOWL = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/fired/bowl")
    public static final ItemPottery FIRED_BOWL = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/unfired/spindle")
    public static final ItemPottery UNFIRED_SPINDLE = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/fired/spindle")
    public static final ItemPottery FIRED_SPINDLE = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/unfired/large_vessel")
    public static final ItemPottery UNFIRED_LARGE_VESSEL = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/unfired/crucible")
    public static final ItemPottery UNFIRED_CRUCIBLE = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/fire_clay")
    public static final Item FIRE_CLAY = (Item)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="bloom/unrefined")
    public static final ItemBloom UNREFINED_BLOOM = (ItemBloom)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="bloom/refined")
    public static final ItemBloom REFINED_BLOOM = (ItemBloom)Helpers.getNull();
    public static final ItemTFC MORTAR = (ItemTFC)Helpers.getNull();
    public static final ItemTFC HALTER = (ItemTFC)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="powder/salt")
    public static final ItemPowder SALT = (ItemPowder)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="quiver")
    public static final ItemQuiver QUIVER = (ItemQuiver)Helpers.getNull();
    public static final ItemWoodenBucket WOODEN_BUCKET = (ItemWoodenBucket)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="metal/bucket/blue_steel")
    public static final ItemMetalBucket BLUE_STEEL_BUCKET = (ItemMetalBucket)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="metal/bucket/red_steel")
    public static final ItemMetalBucket RED_STEEL_BUCKET = (ItemMetalBucket)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="dye/black")
    public static final ItemMisc DYE_BLACK = (ItemMisc)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="dye/blue")
    public static final ItemMisc DYE_BLUE = (ItemMisc)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="dye/brown")
    public static final ItemMisc DYE_BROWN = (ItemMisc)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="dye/white")
    public static final ItemMisc DYE_WHITE = (ItemMisc)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/unfired/clay_brick")
    public static final ItemPottery UNFIRED_BRICK = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ceramics/unfired/clay_flower_pot")
    public static final ItemPottery UNFIRED_FLOWER_POT = (ItemPottery)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="ore/gypsum")
    public static final ItemOreTFC GYPSUM = (ItemOreTFC)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="crop/product/jute_disc")
    public static final Item JUTE_DISC = (Item)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="crop/product/jute_net")
    public static final Item JUTE_NET = (Item)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="crop/product/dirty_jute_net")
    public static final Item DIRTY_JUTE_NET = (Item)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="food/olive_paste")
    public static final Item OLIVE_PASTE = (Item)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="glass_shard")
    public static final Item GLASS_SHARD = (Item)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="stick_bunch")
    public static final Item STICK_BUNCH = (Item)Helpers.getNull();
    @GameRegistry.ObjectHolder(value="wood_ash")
    public static final Item WOOD_ASH = (Item)Helpers.getNull();
    private static ImmutableList<Item> allSimpleItems;
    private static ImmutableList<ItemOreTFC> allOreItems;
    private static ImmutableList<ItemGem> allGemItems;

    public static ImmutableList<Item> getAllSimpleItems() {
        return allSimpleItems;
    }

    public static ImmutableList<ItemOreTFC> getAllOreItems() {
        return allOreItems;
    }

    public static ImmutableList<ItemGem> getAllGemItems() {
        return allGemItems;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Object rock2;
        IForgeRegistry r = event.getRegistry();
        ImmutableList.Builder simpleItems = ImmutableList.builder();
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "wand", new ItemDebug(), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "mortar", new ItemMisc(Size.TINY, Weight.VERY_LIGHT, "mortar"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "halter", new ItemMisc(Size.SMALL, Weight.LIGHT, "halter"), CreativeTabsTFC.CT_MISC));
        ItemsTFC.register((IForgeRegistry<Item>)r, "wooden_bucket", new ItemWoodenBucket(), CreativeTabsTFC.CT_WOOD);
        ItemsTFC.register((IForgeRegistry<Item>)r, "metal/bucket/blue_steel", new ItemMetalBucket(Metal.BLUE_STEEL, Metal.ItemType.BUCKET), CreativeTabsTFC.CT_METAL);
        ItemsTFC.register((IForgeRegistry<Item>)r, "metal/bucket/red_steel", new ItemMetalBucket(Metal.RED_STEEL, Metal.ItemType.BUCKET), CreativeTabsTFC.CT_METAL);
        for (Object rock2 : TFCRegistries.ROCKS.getValuesCollection()) {
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "rock/" + rock2.getRegistryName().func_110623_a().toLowerCase(), new ItemRock((Rock)((Object)rock2)), CreativeTabsTFC.CT_ROCK_ITEMS));
        }
        for (Object rock2 : TFCRegistries.ROCKS.getValuesCollection()) {
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "brick/" + rock2.getRegistryName().func_110623_a().toLowerCase(), new ItemBrickTFC((Rock)((Object)rock2)), CreativeTabsTFC.CT_ROCK_ITEMS));
        }
        Object b = new ImmutableList.Builder();
        for (Ore ore : TFCRegistries.ORES.getValuesCollection()) {
            b.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "ore/" + ore.getRegistryName().func_110623_a(), new ItemOreTFC(ore), CreativeTabsTFC.CT_ROCK_ITEMS));
            if (!ore.isGraded()) continue;
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "ore/small/" + ore.getRegistryName().func_110623_a(), new ItemSmallOre(ore), CreativeTabsTFC.CT_ROCK_ITEMS));
        }
        allOreItems = b.build();
        b = new ImmutableList.Builder();
        rock2 = Gem.values();
        int n = ((Object)rock2).length;
        for (int i = 0; i < n; ++i) {
            Iterator gem = rock2[i];
            b.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "gem/" + ((Enum)((Object)gem)).name().toLowerCase(), new ItemGem((Gem)((Object)gem)), CreativeTabsTFC.CT_GEMS));
        }
        allGemItems = b.build();
        for (Metal.ItemType type : Metal.ItemType.values()) {
            for (Metal metal : TFCRegistries.METALS.getValuesCollection()) {
                if (type == Metal.ItemType.BUCKET || !type.hasType(metal)) continue;
                simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "metal/" + type.name().toLowerCase() + "/" + metal.getRegistryName().func_110623_a(), Metal.ItemType.create(metal, type), CreativeTabsTFC.CT_METAL));
            }
        }
        BlocksTFC.getAllNormalItemBlocks().forEach(x -> ItemsTFC.registerItemBlock((IForgeRegistry<Item>)r, x));
        BlocksTFC.getAllInventoryItemBlocks().forEach(x -> ItemsTFC.registerItemBlock((IForgeRegistry<Item>)r, x));
        BlocksTFC.getAllBarrelItemBlocks().forEach(x -> ItemsTFC.registerItemBlock((IForgeRegistry<Item>)r, x));
        for (BlockLogTFC log : BlocksTFC.getAllLogBlocks()) {
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, log.getRegistryName().func_110623_a(), new ItemBlockTFC((Block)log), CreativeTabsTFC.CT_WOOD));
        }
        for (BlockDoorTFC door : BlocksTFC.getAllDoorBlocks()) {
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, door.getRegistryName().func_110623_a(), new ItemDoorTFC(door), CreativeTabsTFC.CT_DECORATIONS));
        }
        for (BlockSlabTFC.Half slab : BlocksTFC.getAllSlabBlocks()) {
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, slab.getRegistryName().func_110623_a(), new ItemSlabTFC(slab, slab, slab.doubleSlab), CreativeTabsTFC.CT_DECORATIONS));
        }
        for (Tree wood : TFCRegistries.TREES.getValuesCollection()) {
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "wood/lumber/" + wood.getRegistryName().func_110623_a(), new ItemLumberTFC(wood), CreativeTabsTFC.CT_WOOD));
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "wood/boat/" + wood.getRegistryName().func_110623_a(), new ItemBoatTFC(wood), CreativeTabsTFC.CT_WOOD));
        }
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "stick_bunch", new ItemMisc(Size.NORMAL, Weight.LIGHT), CreativeTabsTFC.CT_WOOD));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "stick_bundle", new ItemMisc(Size.VERY_LARGE, Weight.MEDIUM, "log_wood", "stick_bundle"), CreativeTabsTFC.CT_WOOD));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "wood_ash", new ItemMisc(Size.VERY_SMALL, Weight.VERY_LIGHT), CreativeTabsTFC.CT_WOOD));
        for (RockCategory cat : TFCRegistries.ROCK_CATEGORIES.getValuesCollection()) {
            for (Rock.ToolType type : Rock.ToolType.values()) {
                simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "stone/" + type.name().toLowerCase() + "/" + cat.getRegistryName().func_110623_a(), type.create(cat), CreativeTabsTFC.CT_ROCK_ITEMS));
                simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "stone/" + type.name().toLowerCase() + "_head/" + cat.getRegistryName().func_110623_a(), new ItemRockToolHead(cat, type), CreativeTabsTFC.CT_ROCK_ITEMS));
            }
        }
        for (Powder powder : Powder.values()) {
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "powder/" + powder.name().toLowerCase(), new ItemPowder(powder), CreativeTabsTFC.CT_MISC));
        }
        b = Metal.ItemType.values();
        int cat = ((Object)b).length;
        for (int i = 0; i < cat; ++i) {
            Object type = b[i];
            if (!((Metal.ItemType)((Object)type)).hasMold(null)) continue;
            ItemMold item = new ItemMold((Metal.ItemType)((Object)type));
            ItemsTFC.register((IForgeRegistry<Item>)r, "ceramics/fired/mold/" + ((Enum)type).name().toLowerCase(), item, CreativeTabsTFC.CT_POTTERY);
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "ceramics/unfired/mold/" + ((Enum)type).name().toLowerCase(), new ItemUnfiredMold((Metal.ItemType)((Object)type)), CreativeTabsTFC.CT_POTTERY));
        }
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "ceramics/unfired/large_vessel", new ItemUnfiredLargeVessel(), CreativeTabsTFC.CT_POTTERY));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "ceramics/unfired/crucible", new ItemPottery(Size.LARGE, Weight.VERY_HEAVY), CreativeTabsTFC.CT_POTTERY));
        ItemsTFC.registerPottery((ImmutableList.Builder<Item>)simpleItems, (IForgeRegistry<Item>)r, "ceramics/unfired/vessel", "ceramics/fired/vessel", new ItemUnfiredSmallVessel(false), new ItemSmallVessel(false));
        ItemsTFC.registerPottery(null, (IForgeRegistry<Item>)r, "ceramics/unfired/vessel_glazed", "ceramics/fired/vessel_glazed", new ItemUnfiredSmallVessel(true), new ItemSmallVessel(true));
        ItemPottery firedPot = new ItemPottery(Size.LARGE, Weight.LIGHT);
        ItemsTFC.registerPottery((ImmutableList.Builder<Item>)simpleItems, (IForgeRegistry<Item>)r, "ceramics/unfired/pot", "ceramics/fired/pot", new ItemPottery(Size.LARGE, Weight.LIGHT), firedPot);
        OreDictionaryHelper.register(firedPot, "cooking_pot");
        ItemPottery firedBowl = new ItemPottery(Size.VERY_SMALL, Weight.VERY_LIGHT);
        ItemsTFC.registerPottery((ImmutableList.Builder<Item>)simpleItems, (IForgeRegistry<Item>)r, "ceramics/unfired/bowl", "ceramics/fired/bowl", new ItemPottery(Size.VERY_SMALL, Weight.VERY_LIGHT), firedBowl);
        OreDictionaryHelper.register(firedBowl, "bowl");
        ItemsTFC.registerPottery((ImmutableList.Builder<Item>)simpleItems, (IForgeRegistry<Item>)r, "ceramics/unfired/spindle", "ceramics/fired/spindle");
        ItemsTFC.registerPottery((ImmutableList.Builder<Item>)simpleItems, (IForgeRegistry<Item>)r, "ceramics/unfired/fire_brick", "ceramics/fired/fire_brick");
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "ceramics/fire_clay", new ItemMisc(Size.VERY_SMALL, Weight.VERY_LIGHT, "fire_clay"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "ceramics/unfired/jug", new ItemPottery(), CreativeTabsTFC.CT_POTTERY));
        ItemsTFC.register((IForgeRegistry<Item>)r, "ceramics/fired/jug", new ItemJug(), CreativeTabsTFC.CT_POTTERY);
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "ceramics/unfired/clay_brick", new ItemPottery(), CreativeTabsTFC.CT_POTTERY));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "ceramics/unfired/clay_flower_pot", new ItemPottery(), CreativeTabsTFC.CT_POTTERY));
        for (Crop crop : Crop.values()) {
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "crop/seeds/" + crop.name().toLowerCase(), new ItemSeedsTFC(crop), CreativeTabsTFC.CT_FOOD));
        }
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "crop/product/jute", new ItemMisc(Size.SMALL, Weight.VERY_LIGHT), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "crop/product/jute_fiber", new ItemMisc(Size.SMALL, Weight.VERY_LIGHT), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "crop/product/burlap_cloth", new ItemMisc(Size.SMALL, Weight.VERY_LIGHT), CreativeTabsTFC.CT_MISC));
        for (Enum food : Food.values()) {
            if (((Food)food).getCategory() == Food.Category.MEAL) continue;
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "food/" + food.name().toLowerCase(), new ItemFoodTFC((Food)food), CreativeTabsTFC.CT_FOOD));
        }
        for (Enum food : new Food[]{Food.BARLEY_BREAD_SANDWICH, Food.CORNBREAD_SANDWICH, Food.OAT_BREAD_SANDWICH, Food.RICE_BREAD_SANDWICH, Food.RYE_BREAD_SANDWICH, Food.WHEAT_BREAD_SANDWICH}) {
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "food/" + food.name().toLowerCase(), new ItemSandwich((Food)food), CreativeTabsTFC.CT_FOOD));
        }
        for (Enum food : new Food[]{Food.SOUP_GRAIN, Food.SOUP_FRUIT, Food.SOUP_VEGETABLE, Food.SOUP_MEAT, Food.SOUP_DAIRY}) {
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "food/" + food.name().toLowerCase(), new ItemDynamicBowlFood((Food)food), CreativeTabsTFC.CT_FOOD));
        }
        for (Enum food : new Food[]{Food.SALAD_GRAIN, Food.SALAD_FRUIT, Food.SALAD_VEGETABLE, Food.SALAD_MEAT, Food.SALAD_DAIRY}) {
            simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "food/" + food.name().toLowerCase(), new ItemDynamicBowlFood((Food)food), CreativeTabsTFC.CT_FOOD));
        }
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "food/olive_paste", new ItemMisc(Size.VERY_SMALL, Weight.VERY_LIGHT), CreativeTabsTFC.CT_FOOD));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "crop/product/jute_disc", new ItemMisc(Size.VERY_SMALL, Weight.VERY_LIGHT), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "crop/product/olive_jute_disc", new ItemMisc(Size.VERY_SMALL, Weight.VERY_LIGHT), CreativeTabsTFC.CT_FOOD));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "crop/product/jute_net", new ItemMisc(Size.VERY_SMALL, Weight.VERY_LIGHT), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "crop/product/dirty_jute_net", new ItemMisc(Size.VERY_SMALL, Weight.VERY_LIGHT), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "firestarter", new ItemFireStarter(), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "straw", new ItemMisc(Size.SMALL, Weight.VERY_LIGHT, "kindling", "straw"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "glass_shard", new ItemMisc(Size.VERY_SMALL, Weight.VERY_LIGHT), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "handstone", new ItemCraftingTool(250, Size.NORMAL, Weight.VERY_HEAVY, "handstone"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "spindle", new ItemCraftingTool(40, Size.NORMAL, Weight.MEDIUM, "spindle"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "bloom/unrefined", new ItemBloom(false), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "bloom/refined", new ItemBloom(true), CreativeTabsTFC.CT_MISC));
        for (Enum size : ItemAnimalHide.HideSize.values()) {
            for (ItemAnimalHide.HideType type : ItemAnimalHide.HideType.values()) {
                simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, ("hide/" + type.name() + "/" + size.name()).toLowerCase(), new ItemAnimalHide(type, (ItemAnimalHide.HideSize)size), CreativeTabsTFC.CT_MISC));
            }
        }
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "quiver", new ItemQuiver(), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "animal/product/wool", new ItemMisc(Size.SMALL, Weight.LIGHT), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "animal/product/wool_yarn", new ItemMisc(Size.VERY_SMALL, Weight.VERY_LIGHT, "string"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "animal/product/wool_cloth", new ItemMisc(Size.SMALL, Weight.LIGHT, "cloth_high_quality"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "animal/product/silk_cloth", new ItemMisc(Size.SMALL, Weight.LIGHT, "cloth_high_quality"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "dye/black", new ItemMisc(Size.TINY, Weight.LIGHT, "dye_black"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "dye/blue", new ItemMisc(Size.TINY, Weight.LIGHT, "dye_blue"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "dye/white", new ItemMisc(Size.TINY, Weight.LIGHT, "dye_white"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "dye/brown", new ItemMisc(Size.TINY, Weight.LIGHT, "dye_brown"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "alabaster_brick", new ItemMisc(Size.VERY_SMALL, Weight.LIGHT), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "glue", new ItemMisc(Size.TINY, Weight.LIGHT, "slimeball", "glue"), CreativeTabsTFC.CT_MISC));
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "brass_mechanisms", new ItemMisc(Size.NORMAL, Weight.LIGHT), CreativeTabsTFC.CT_MISC));
        ItemsTFC.register((IForgeRegistry<Item>)r, "goldpan", new ItemGoldPan(), CreativeTabsTFC.CT_MISC);
        simpleItems.add((Object)ItemsTFC.register((IForgeRegistry<Item>)r, "wrought_iron_grill", new ItemMisc(Size.LARGE, Weight.HEAVY, "grill"), CreativeTabsTFC.CT_MISC));
        allSimpleItems = simpleItems.build();
        OreDictionaryHelper.init();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerVanillaOverrides(RegistryEvent.Register<Item> event) {
        TerraFirmaCraft.getLog().info("The below warnings about unintended overrides are normal. The override is intended. ;)");
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemSnow(Blocks.field_150431_aC).setRegistryName("minecraft", "snow_layer"), ((Item)new ItemGlassBottleTFC().setRegistryName(Items.field_151069_bo.getRegistryName())).func_77655_b("glassBottle")});
        if (ConfigTFC.General.OVERRIDES.enableTorchOverride) {
            event.getRegistry().register(new ItemBlockTorch(Blocks.field_150478_aa).setRegistryName("minecraft", "torch"));
        }
    }

    public static void init() {
        for (Metal metal : TFCRegistries.METALS.getValuesCollection()) {
            if (metal.getToolMetal() == null) continue;
            metal.getToolMetal().setRepairItem(new ItemStack(ItemMetal.get(metal, Metal.ItemType.SCRAP)));
        }
    }

    private static void registerPottery(ImmutableList.Builder<Item> items, IForgeRegistry<Item> r, String nameUnfired, String nameFired) {
        ItemsTFC.registerPottery(items, r, nameUnfired, nameFired, new ItemPottery(), new ItemPottery());
    }

    private static void registerPottery(ImmutableList.Builder<Item> items, IForgeRegistry<Item> r, String nameUnfired, String nameFired, ItemPottery unfiredItem, ItemPottery firedItem) {
        ItemsTFC.register(r, nameFired, firedItem, CreativeTabsTFC.CT_POTTERY);
        ItemsTFC.register(r, nameUnfired, unfiredItem, CreativeTabsTFC.CT_POTTERY);
        if (items != null) {
            items.add((Object[])new Item[]{firedItem, unfiredItem});
        }
    }

    private static void registerItemBlock(IForgeRegistry<Item> r, ItemBlock item) {
        item.setRegistryName(item.func_179223_d().getRegistryName());
        item.func_77637_a(item.func_179223_d().func_149708_J());
        r.register((IForgeRegistryEntry)item);
    }

    private static <T extends Item> T register(IForgeRegistry<Item> r, String name, T item, CreativeTabs ct) {
        item.setRegistryName("tfc", name);
        item.func_77655_b("tfc." + name.replace('/', '.'));
        item.func_77637_a(ct);
        r.register(item);
        return item;
    }
}

