/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items;

import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.objects.Powder;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@ParametersAreNonnullByDefault
public class ItemPowder
extends ItemTFC {
    private static final EnumMap<Powder, ItemPowder> MAP = new EnumMap(Powder.class);
    private final Powder powder;

    public static ItemPowder get(Powder powder) {
        return MAP.get((Object)powder);
    }

    public static ItemStack get(Powder powder, int amount) {
        return new ItemStack((Item)MAP.get((Object)powder), amount);
    }

    public ItemPowder(Powder powder) {
        this.powder = powder;
        if (MAP.put(powder, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_77656_e(0);
        OreDictionaryHelper.register(this, new Object[]{"dust", powder});
        if (powder == Powder.LAPIS_LAZULI) {
            OreDictionaryHelper.register(this, "dust", "lapis");
        }
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.SMALL;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.VERY_LIGHT;
    }

    @Nonnull
    public Powder getPowder() {
        return this.powder;
    }
}

