/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.blocks.stone.BlockRockVariant;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.objects.items.metal.ItemSmallOre;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemGoldPan
extends ItemTFC {
    public static final String[] TYPES = new String[]{"empty", "sand", "gravel", "clay", "dirt"};

    public ItemGoldPan() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77627_a(true);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        if (player.func_184586_b(hand).func_77952_i() > 0 && !this.canPan(worldIn, player)) {
            return EnumActionResult.FAIL;
        }
        player.func_184598_c(hand);
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (!stack.func_190926_b() && !world.field_72995_K && entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (stack.func_77952_i() > 0) {
                if (this.canPan(world, player)) {
                    Chunk chunk = world.func_175726_f(player.func_180425_c());
                    ChunkDataTFC chunkDataTFC = ChunkDataTFC.get(chunk);
                    if (stack.func_77952_i() == 1 || stack.func_77952_i() == 2) {
                        if (chunkDataTFC.canWork(6)) {
                            Random rand = new Random(world.func_72905_C() + (long)chunk.func_76632_l().field_77276_a * 241179128412L + (long)chunk.func_76632_l().field_77275_b * 327910215471L);
                            List<Ore> chunkOres = TFCRegistries.ORES.getValuesCollection().stream().filter(Ore::canPan).filter(x -> rand.nextDouble() < x.getChunkChance()).collect(Collectors.toList());
                            chunkOres.forEach(x -> {
                                if (Constants.RNG.nextDouble() < x.getPanChance()) {
                                    Helpers.spawnItemStack(world, player.func_180425_c(), new ItemStack((Item)ItemSmallOre.get(x)));
                                }
                            });
                            chunkDataTFC.addWork(6);
                            stack.func_77964_b(0);
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.tooltip.goldpan.chunkworked", new Object[0]));
                        }
                    }
                    if ((double)Constants.RNG.nextFloat() < 0.01) {
                        stack.func_190918_g(1);
                        world.func_184133_a(null, entityLiving.func_180425_c(), TFCSounds.CERAMIC_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                }
            } else {
                RayTraceResult result = this.func_77621_a(world, player, false);
                if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
                    return stack;
                }
                BlockPos pos = result.func_178782_a();
                IBlockState state = world.func_180495_p(pos);
                if (!(state.func_177230_c() instanceof BlockRockVariant) || result.field_178784_b != null && world.func_180495_p(pos.func_177972_a(result.field_178784_b)).func_185904_a().func_76224_d()) {
                    return stack;
                }
                Rock.Type type = ((BlockRockVariant)state.func_177230_c()).getType();
                if (type == Rock.Type.SAND) {
                    stack.func_77964_b(1);
                } else if (type == Rock.Type.GRAVEL) {
                    stack.func_77964_b(2);
                }
                if (stack.func_77952_i() > 0 && Constants.RNG.nextFloat() < 0.1f) {
                    world.func_175698_g(pos);
                }
            }
        }
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + TYPES[stack.func_77952_i()];
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return stack.func_77952_i() > 0 ? 54 : 1;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int meta = 0; meta < TYPES.length; ++meta) {
                items.add((Object)new ItemStack((Item)this, 1, meta));
            }
        }
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.NORMAL;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.MEDIUM;
    }

    @Override
    public boolean canStack(ItemStack stack) {
        return false;
    }

    private boolean canPan(World world, EntityPlayer player) {
        RayTraceResult result = this.func_77621_a(world, player, true);
        if (result == null) {
            return false;
        }
        if (result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return false;
        }
        BlockPos pos = result.func_178782_a();
        return world.func_180495_p(pos).func_185904_a() == Material.field_151586_h;
    }
}

