/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items;

import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.objects.Gem;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemGem
extends ItemTFC {
    private static final EnumMap<Gem, ItemGem> MAP = new EnumMap(Gem.class);
    public final Gem gem;

    public static ItemGem get(Gem gem) {
        return MAP.get((Object)gem);
    }

    public static ItemStack get(Gem ore, Gem.Grade grade, int amount) {
        return new ItemStack((Item)MAP.get((Object)ore), amount, grade.ordinal());
    }

    public ItemGem(Gem gem) {
        this.gem = gem;
        if (MAP.put(gem, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_77656_e(0);
        this.func_77627_a(true);
        for (Gem.Grade grade : Gem.Grade.values()) {
            if (grade == Gem.Grade.NORMAL) {
                OreDictionaryHelper.registerMeta(this, grade.ordinal(), new Object[]{"gem", gem});
            } else {
                OreDictionaryHelper.registerMeta(this, grade.ordinal(), new Object[]{"gem", grade, gem});
            }
            OreDictionaryHelper.registerMeta(this, grade.ordinal(), new Object[]{"gem", grade});
        }
    }

    public String func_77667_c(ItemStack stack) {
        Gem.Grade grade = this.getGradeFromStack(stack);
        if (grade != null) {
            return super.func_77667_c(stack) + "." + grade.name().toLowerCase();
        }
        return super.func_77667_c(stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Gem.Grade grade : Gem.Grade.values()) {
                items.add((Object)new ItemStack((Item)this, 1, grade.ordinal()));
            }
        }
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.SMALL;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.VERY_LIGHT;
    }

    @Nullable
    private Gem.Grade getGradeFromStack(ItemStack stack) {
        return Gem.Grade.valueOf(stack.func_77952_i());
    }
}

