/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.objects.te.TEFirePit;
import net.dries007.tfc.objects.te.TELogPile;
import net.dries007.tfc.objects.te.TEPitKiln;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemFireStarter
extends ItemTFC {
    public static boolean onIgnition(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (OreDictionaryHelper.doesStackMatchOre(stack, "fireStarter")) {
            if (stack.func_77973_b().func_77645_m()) {
                Helpers.damageItem(stack);
            } else {
                stack.func_190918_g(1);
            }
            return true;
        }
        return OreDictionaryHelper.doesStackMatchOre(stack, "infiniteFire");
    }

    public static boolean canIgnite(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return OreDictionaryHelper.doesStackMatchOre(stack, "fireStarter") || OreDictionaryHelper.doesStackMatchOre(stack, "infiniteFire");
    }

    public ItemFireStarter() {
        this.func_77656_e(8);
        this.func_77625_d(1);
        this.setNoRepair();
        OreDictionaryHelper.register(this, "fire", "starter");
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND || worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        if (this.canStartFire(worldIn, player) == null) {
            return EnumActionResult.FAIL;
        }
        player.func_184598_c(hand);
        return EnumActionResult.SUCCESS;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entityLivingBase, int countLeft) {
        if (!(entityLivingBase instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLivingBase;
        RayTraceResult result = this.canStartFire(player.field_70170_p, player);
        if (result == null) {
            player.func_184602_cy();
            return;
        }
        int total = this.func_77626_a(stack);
        int count = total - countLeft;
        BlockPos pos = result.func_178782_a().func_177982_a(0, 1, 0);
        World world = player.field_70170_p;
        float chance = (float)ConfigTFC.General.MISC.fireStarterChance;
        if (world.func_175727_C(pos)) {
            chance = (float)((double)chance * 0.5);
        }
        if (world.field_72995_K) {
            if ((double)field_77697_d.nextFloat() + 0.3 < (double)count / (double)total) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c, 0.0, (double)0.1f, 0.0, new int[0]);
            }
            if (countLeft < 10 && (double)field_77697_d.nextFloat() + 0.3 < (double)count / (double)total) {
                world.func_175688_a(EnumParticleTypes.FLAME, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            }
            if (count % 3 == 1) {
                player.func_184185_a(TFCSounds.FIRE_STARTER, 0.5f, 0.05f);
            }
        } else if (countLeft == 1) {
            stack.func_77972_a(1, (EntityLivingBase)player);
            IBlockState state = world.func_180495_p(pos.func_177977_b());
            if (state.func_177230_c() == BlocksTFC.LOG_PILE) {
                if (field_77697_d.nextFloat() < chance) {
                    world.func_175656_a(pos.func_177977_b(), state.func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(true)));
                    TELogPile te = Helpers.getTE((IBlockAccess)world, pos.func_177977_b(), TELogPile.class);
                    if (te != null) {
                        te.light();
                        TFCTriggers.LIT_TRIGGER.trigger((EntityPlayerMP)player, state.func_177230_c());
                    }
                    if (Blocks.field_150480_ab.func_176196_c(world, pos)) {
                        world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            } else if (state.func_177230_c() == BlocksTFC.PIT_KILN) {
                TEPitKiln te;
                if (field_77697_d.nextFloat() < chance && (te = Helpers.getTE((IBlockAccess)world, pos.func_177977_b(), TEPitKiln.class)) != null) {
                    te.tryLight();
                    TFCTriggers.LIT_TRIGGER.trigger((EntityPlayerMP)player, state.func_177230_c());
                }
            } else {
                List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 2, 1)));
                ArrayList<EntityItem> stuffToUse = new ArrayList<EntityItem>();
                int sticks = 0;
                int kindling = 0;
                EntityItem log = null;
                for (EntityItem entity : items) {
                    if (OreDictionaryHelper.doesStackMatchOre(entity.func_92059_d(), "stickWood")) {
                        sticks += entity.func_92059_d().func_190916_E();
                        stuffToUse.add(entity);
                        continue;
                    }
                    if (OreDictionaryHelper.doesStackMatchOre(entity.func_92059_d(), "kindling")) {
                        kindling += entity.func_92059_d().func_190916_E();
                        stuffToUse.add(entity);
                        continue;
                    }
                    if (log != null || !OreDictionaryHelper.doesStackMatchOre(entity.func_92059_d(), "logWood")) continue;
                    log = entity;
                }
                if (sticks >= 3 && log != null) {
                    float kindlingModifier = Math.min(0.1f * (float)kindling, 0.5f);
                    if (field_77697_d.nextFloat() < chance + kindlingModifier) {
                        world.func_175656_a(pos, BlocksTFC.FIREPIT.func_176223_P().func_177226_a((IProperty)ILightableBlock.LIT, (Comparable)Boolean.valueOf(true)));
                        TEFirePit te = Helpers.getTE((IBlockAccess)world, pos, TEFirePit.class);
                        if (te != null) {
                            te.onCreate(log.func_92059_d());
                        }
                        stuffToUse.forEach(Entity::func_70106_y);
                        log.func_92059_d().func_190918_g(1);
                        if (log.func_92059_d().func_190916_E() == 0) {
                            log.func_70106_y();
                        }
                        TFCTriggers.LIT_TRIGGER.trigger((EntityPlayerMP)player, world.func_180495_p(pos).func_177230_c());
                    }
                } else if (Blocks.field_150480_ab.func_176196_c(world, pos)) {
                    world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.SMALL;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.LIGHT;
    }

    @Override
    public boolean canStack(@Nonnull ItemStack stack) {
        return false;
    }

    @Nullable
    private RayTraceResult canStartFire(World world, EntityPlayer player) {
        RayTraceResult result = this.func_77621_a(world, player, true);
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = result.func_178782_a();
            IBlockState current = world.func_180495_p(pos);
            if (result.field_178784_b == EnumFacing.UP && current.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && !current.func_185904_a().func_76224_d() && world.func_175623_d(pos.func_177984_a())) {
                return result;
            }
        }
        return null;
    }
}

