/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.forge.CapabilityForgeable;
import net.dries007.tfc.api.capability.forge.ForgeableMeasurableMetalHandler;
import net.dries007.tfc.api.capability.forge.IForgeable;
import net.dries007.tfc.api.capability.forge.IForgeableMeasurableMetal;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class ItemBloom
extends ItemTFC
implements IMetalItem {
    private final boolean meltable;

    public ItemBloom(boolean meltable) {
        this.meltable = meltable;
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.LARGE;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.HEAVY;
    }

    @Override
    @Nullable
    public Metal getMetal(ItemStack stack) {
        IForgeable cap = (IForgeable)stack.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
        if (cap instanceof IForgeableMeasurableMetal) {
            return ((IForgeableMeasurableMetal)cap).getMetal();
        }
        return Metal.UNKNOWN;
    }

    @Override
    public int getSmeltAmount(ItemStack stack) {
        IForgeable cap = (IForgeable)stack.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
        if (cap instanceof IForgeableMeasurableMetal) {
            int amount = ((IForgeableMeasurableMetal)cap).getMetalAmount();
            if (amount > 100) {
                amount = 100;
            }
            return amount;
        }
        return 0;
    }

    @Override
    public boolean canMelt(ItemStack stack) {
        return this.meltable;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addMetalInfo(ItemStack stack, List<String> text) {
        IForgeable cap = (IForgeable)stack.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
        if (cap instanceof IForgeableMeasurableMetal) {
            text.add("");
            text.add(I18n.func_135052_a((String)"tfc.tooltip.metal", (Object[])new Object[]{I18n.func_135052_a((String)Helpers.getTypeName(((IForgeableMeasurableMetal)cap).getMetal()), (Object[])new Object[0])}));
            text.add(I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{((IForgeableMeasurableMetal)cap).getMetalAmount()}));
            text.add(I18n.func_135052_a((String)Helpers.getEnumName(((IForgeableMeasurableMetal)cap).getMetal().getTier()), (Object[])new Object[0]));
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + this.getMetal(stack).getRegistryName().func_110623_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 100; i <= 400; i += 100) {
                ItemStack stack = new ItemStack((Item)this);
                IForgeable cap = (IForgeable)stack.getCapability(CapabilityForgeable.FORGEABLE_CAPABILITY, null);
                if (!(cap instanceof IForgeableMeasurableMetal)) continue;
                IForgeableMeasurableMetal handler = (IForgeableMeasurableMetal)cap;
                handler.setMetal(Metal.WROUGHT_IRON);
                handler.setMetalAmount(i);
                items.add((Object)stack);
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt == null) {
            return new ForgeableMeasurableMetalHandler(Metal.WROUGHT_IRON, 100);
        }
        return new ForgeableMeasurableMetalHandler(nbt);
    }
}

