/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.objects.blocks.BlockPlacedHide;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.BlockBed;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class ItemAnimalHide
extends ItemTFC {
    private static final Map<HideType, Map<HideSize, ItemAnimalHide>> TABLE = new HashMap<HideType, Map<HideSize, ItemAnimalHide>>();
    protected final HideSize size;
    private final HideType type;

    @Nonnull
    public static ItemAnimalHide get(HideType type, HideSize size) {
        return TABLE.get((Object)type).get((Object)size);
    }

    public ItemAnimalHide(HideType type, HideSize size) {
        this.type = type;
        this.size = size;
        if (!TABLE.containsKey((Object)type)) {
            TABLE.put(type, new HashMap());
        }
        TABLE.get((Object)type).put(size, this);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (ConfigTFC.General.OVERRIDES.enableThatchBed && this.type == HideType.RAW && this.size == HideSize.LARGE && facing == EnumFacing.UP && worldIn.func_180495_p(pos).func_177230_c() == BlocksTFC.THATCH && worldIn.func_180495_p(pos.func_177972_a(player.func_174811_aO())).func_177230_c() == BlocksTFC.THATCH) {
            BlockPos headPos = pos.func_177972_a(player.func_174811_aO());
            if (player.func_175151_a(pos, facing, stack) && player.func_175151_a(headPos, facing, stack)) {
                if (!worldIn.field_72995_K) {
                    IBlockState footState = BlocksTFC.THATCH_BED.func_176223_P().func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)player.func_174811_aO()).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT);
                    IBlockState headState = BlocksTFC.THATCH_BED.func_176223_P().func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)player.func_174811_aO().func_176734_d()).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD);
                    worldIn.func_180501_a(pos, footState, 10);
                    worldIn.func_180501_a(headPos, headState, 10);
                    SoundType soundtype = BlocksTFC.THATCH_BED.getSoundType(footState, worldIn, pos, (Entity)player);
                    worldIn.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                    stack.func_190918_g(1);
                    player.func_184611_a(hand, stack);
                }
                return EnumActionResult.SUCCESS;
            }
        } else if (this.type == HideType.SOAKED) {
            IBlockState stateAt = worldIn.func_180495_p(pos);
            BlockPos posAbove = pos.func_177984_a();
            IBlockState stateAbove = worldIn.func_180495_p(posAbove);
            ItemStack stackAt = stateAt.func_177230_c().getPickBlock(stateAt, null, worldIn, pos, player);
            if (facing == EnumFacing.UP && OreDictionaryHelper.doesStackMatchOre(stackAt, "logWood") && stateAbove.func_177230_c().isAir(stateAbove, (IBlockAccess)worldIn, posAbove)) {
                if (!worldIn.field_72995_K) {
                    worldIn.func_175656_a(posAbove, BlocksTFC.PLACED_HIDE.func_176223_P().func_177226_a(BlockPlacedHide.SIZE, (Comparable)((Object)this.size)));
                }
                stack.func_190918_g(1);
                player.func_184611_a(hand, stack);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ItemStack getContainerItem(ItemStack itemStack) {
        switch (this.size) {
            case SMALL: {
                return new ItemStack((Item)ItemAnimalHide.get(HideType.RAW, HideSize.SMALL));
            }
            case MEDIUM: {
                return new ItemStack((Item)ItemAnimalHide.get(HideType.RAW, HideSize.MEDIUM));
            }
            case LARGE: {
                return new ItemStack((Item)ItemAnimalHide.get(HideType.RAW, HideSize.LARGE));
            }
        }
        return new ItemStack((Item)ItemAnimalHide.get(HideType.RAW, HideSize.SMALL));
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.type == HideType.SHEEPSKIN;
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.NORMAL;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        switch (this.size) {
            case LARGE: {
                return Weight.MEDIUM;
            }
            case MEDIUM: {
                return Weight.LIGHT;
            }
        }
        return Weight.VERY_LIGHT;
    }

    public static enum HideType {
        RAW,
        SOAKED,
        SCRAPED,
        PREPARED,
        SHEEPSKIN;

    }

    public static enum HideSize implements IStringSerializable
    {
        SMALL,
        MEDIUM,
        LARGE;

        private static final HideSize[] VALUES;

        @Nonnull
        public static HideSize valueOf(int index) {
            return index < 0 || index > VALUES.length ? MEDIUM : VALUES[index];
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            VALUES = HideSize.values();
        }
    }
}

