/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.inventory.ingredient;

import javax.annotation.Nonnull;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class IngredientOreDict
implements IIngredient<ItemStack> {
    private final String oreName;
    private final int amount;

    IngredientOreDict(@Nonnull String oreName) {
        this(oreName, 1);
    }

    IngredientOreDict(@Nonnull String oreName, int amount) {
        this.oreName = oreName;
        this.amount = amount;
    }

    @Override
    public NonNullList<ItemStack> getValidIngredients() {
        NonNullList output = NonNullList.func_191196_a();
        for (ItemStack out : OreDictionary.getOres((String)this.oreName)) {
            ItemStack addToList = out.func_77946_l();
            addToList.func_190920_e(this.amount);
            output.add((Object)addToList);
        }
        return output;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.testIgnoreCount(stack) && stack.func_190916_E() >= this.amount;
    }

    @Override
    public boolean testIgnoreCount(ItemStack stack) {
        return stack != null && !stack.func_190926_b() && OreDictionaryHelper.doesStackMatchOre(stack, this.oreName);
    }

    @Override
    @Nonnull
    public ItemStack consume(ItemStack input) {
        input.func_190918_g(this.amount);
        return input;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Nonnull
    public String getOreName() {
        return this.oreName;
    }
}

