/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.inventory.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.objects.inventory.capability.ISlotCallback;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.VanillaDoubleChestItemHandler;

public class TFCDoubleChestItemHandler
extends VanillaDoubleChestItemHandler {
    @Nullable
    public static VanillaDoubleChestItemHandler get(TileEntityChest chest) {
        World world = chest.func_145831_w();
        BlockPos pos = chest.func_174877_v();
        if (world == null || pos == null || !world.func_175667_e(pos)) {
            return null;
        }
        Block blockType = chest.func_145838_q();
        EnumFacing[] horizontals = EnumFacing.field_176754_o;
        for (int i = horizontals.length - 1; i >= 0; --i) {
            TileEntity otherTE;
            EnumFacing enumfacing = horizontals[i];
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = world.func_180495_p(blockpos).func_177230_c();
            if (block != blockType || !((otherTE = world.func_175625_s(blockpos)) instanceof TileEntityChest)) continue;
            TileEntityChest otherChest = (TileEntityChest)otherTE;
            return new TFCDoubleChestItemHandler(chest, otherChest, enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH);
        }
        return NO_ADJACENT_CHESTS_INSTANCE;
    }

    public TFCDoubleChestItemHandler(@Nullable TileEntityChest mainChest, @Nullable TileEntityChest other, boolean mainChestIsUpper) {
        super(mainChest, other, mainChestIsUpper);
    }

    public int getSlots() {
        return 36;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        boolean accessingUpperChest = slot < 18;
        int targetSlot = accessingUpperChest ? slot : slot - 18;
        TileEntityChest chest = this.getChest(accessingUpperChest);
        return chest != null ? chest.func_70301_a(targetSlot) : ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        IItemHandler singleHandler;
        boolean accessingUpperChest = slot < 18;
        int targetSlot = accessingUpperChest ? slot : slot - 18;
        TileEntityChest chest = this.getChest(accessingUpperChest);
        if (chest != null && (singleHandler = chest.getSingleChestHandler()) instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)singleHandler).setStackInSlot(targetSlot, stack);
        }
        if ((chest = this.getChest(!accessingUpperChest)) != null) {
            chest.func_70296_d();
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean accessingUpperChest = slot < 18;
        int targetSlot = accessingUpperChest ? slot : slot - 18;
        TileEntityChest chest = this.getChest(accessingUpperChest);
        if (chest == null) {
            return stack;
        }
        if (chest instanceof ISlotCallback && !((ISlotCallback)chest).isItemValid(slot, stack)) {
            return stack;
        }
        int starting = stack.func_190916_E();
        ItemStack ret = chest.getSingleChestHandler().insertItem(targetSlot, stack, simulate);
        if (ret.func_190916_E() != starting && !simulate && (chest = this.getChest(!accessingUpperChest)) != null) {
            chest.func_70296_d();
        }
        return ret;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        boolean accessingUpperChest = slot < 18;
        int targetSlot = accessingUpperChest ? slot : slot - 18;
        TileEntityChest chest = this.getChest(accessingUpperChest);
        if (chest == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = chest.getSingleChestHandler().extractItem(targetSlot, amount, simulate);
        if (!ret.func_190926_b() && !simulate && (chest = this.getChest(!accessingUpperChest)) != null) {
            chest.func_70296_d();
        }
        return ret;
    }

    public int getSlotLimit(int slot) {
        boolean accessingUpperChest = slot < 18;
        return this.getChest(accessingUpperChest).func_70297_j_();
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        boolean accessingUpperChest = slot < 18;
        int targetSlot = accessingUpperChest ? slot : slot - 18;
        TileEntityChest chest = this.getChest(accessingUpperChest);
        if (chest != null) {
            return chest.getSingleChestHandler().isItemValid(targetSlot, stack);
        }
        return true;
    }
}

