/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.inventory.capability;

import javax.annotation.Nonnull;
import net.dries007.tfc.objects.inventory.capability.IItemHandlerSidedCallback;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemHandlerSidedWrapper
implements IItemHandlerModifiable {
    private final IItemHandlerSidedCallback callback;
    private final IItemHandlerModifiable handler;
    private final EnumFacing side;

    public ItemHandlerSidedWrapper(IItemHandlerSidedCallback callback, IItemHandlerModifiable handler, EnumFacing side) {
        this.callback = callback;
        this.handler = handler;
        this.side = side;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.handler.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.handler.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.callback.canInsert(slot, stack, this.side)) {
            return this.handler.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.callback.canExtract(slot, this.side)) {
            return this.handler.extractItem(slot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.handler.getSlotLimit(slot);
    }
}

