/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.IHuntable;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalMammal;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@ParametersAreNonnullByDefault
public class EntityRabbitTFC
extends EntityAnimalMammal
implements IHuntable {
    private static final int DAYS_TO_ADULTHOOD = 16;
    private static final DataParameter<Integer> RABBIT_TYPE = EntityDataManager.func_187226_a(EntityRabbitTFC.class, (DataSerializer)DataSerializers.field_187192_b);
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;

    public EntityRabbitTFC(World worldIn) {
        this(worldIn, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityRabbitTFC.getRandomGrowth(16, 0));
    }

    public EntityRabbitTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn, gender, birthDay);
        this.func_70105_a(0.4f, 0.5f);
        this.field_70767_i = new RabbitJumpHelper(this);
        this.field_70765_h = new RabbitMoveHelper(this);
        this.setMovementSpeed(0.0);
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!(BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome) || biomeType != BiomeHelper.BiomeType.TAIGA && biomeType != BiomeHelper.BiomeType.PLAINS && biomeType != BiomeHelper.BiomeType.TUNDRA)) {
            return ConfigTFC.Animals.RABBIT.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.ELDER_AND_POPULATION;
    }

    @Override
    public int getMinGroupSize() {
        return 4;
    }

    @Override
    public int getMaxGroupSize() {
        return 7;
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.field_70122_E) {
            RabbitJumpHelper entityrabbit$rabbitjumphelper;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.checkLandingDelay();
            }
            if (!(entityrabbit$rabbitjumphelper = (RabbitJumpHelper)this.field_70767_i).isJumping()) {
                if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vec3d vec3d = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && path.func_75873_e() < path.func_75874_d()) {
                        vec3d = path.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(vec3d.field_72450_a, vec3d.field_72449_c);
                    this.startJumping();
                }
            } else if (!entityrabbit$rabbitjumphelper.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.func_174808_Z();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public int getRabbitType() {
        return (Integer)this.field_70180_af.func_187225_a(RABBIT_TYPE);
    }

    public void setRabbitType(int rabbitTypeId) {
        this.field_70180_af.func_187227_b(RABBIT_TYPE, (Object)rabbitTypeId);
    }

    @SideOnly(value=Side.CLIENT)
    public float getJumpCompletion(float p_175521_1_) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + p_175521_1_) / (float)this.jumpDuration;
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    public void startJumping() {
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    @Override
    public void birthChildren() {
        int numberOfChildren = 5 + this.field_70146_Z.nextInt(5);
        for (int i = 0; i < numberOfChildren; ++i) {
            EntityRabbitTFC baby = new EntityRabbitTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
            baby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)baby);
        }
    }

    @Override
    public long gestationDays() {
        return 0L;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RABBIT_TYPE, (Object)0);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.func_70637_d(false);
        }
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("RabbitType", this.getRabbitType());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRabbitType(compound.func_74762_e("RabbitType"));
    }

    @Nonnull
    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    @Override
    public int getDaysToAdulthood() {
        return 16;
    }

    @Override
    public int getDaysToElderly() {
        return 0;
    }

    @Override
    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    @Override
    public double getOldDeathChance() {
        return 0.0;
    }

    protected void func_184651_r() {
        double speedMult = 2.2;
        EntityAnimalTFC.addWildPreyAI(this, speedMult);
        EntityAnimalTFC.addCommonPreyAI(this, speedMult);
        this.field_70714_bg.field_75782_a.removeIf(entry -> entry.field_75733_a instanceof EntityAIPanic);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanic(this, 1.4 * speedMult));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.2));
        for (ItemStack is : OreDictionary.getOres((String)"carrot")) {
            Item item = is.func_77973_b();
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.4, item, false));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187816_ej;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_RABBIT;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        int i = this.getRandomRabbitType();
        if (livingdata instanceof RabbitTypeData) {
            i = ((RabbitTypeData)livingdata).typeData;
        } else {
            livingdata = new RabbitTypeData(i);
        }
        this.setRabbitType(i);
        return livingdata;
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.field_187824_en;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187822_em;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187820_el;
    }

    protected float func_175134_bD() {
        if (!(this.field_70123_F || this.field_70765_h.func_75640_a() && !(this.field_70765_h.func_179919_e() <= this.field_70163_u + 0.5))) {
            Path path = this.field_70699_by.func_75505_d();
            if (path != null && path.func_75873_e() < path.func_75874_d()) {
                Vec3d vec3d = path.func_75878_a((Entity)this);
                if (vec3d.field_72448_b > this.field_70163_u + 0.5) {
                    return 0.5f;
                }
            }
            return this.field_70765_h.func_75638_b() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    protected void func_70664_aZ() {
        double d1;
        super.func_70664_aZ();
        double d0 = this.field_70765_h.func_75638_b();
        if (d0 > 0.0 && (d1 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) < 0.010000000000000002) {
            this.func_191958_b(0.0f, 0.0f, 1.0f, 0.1f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    public void func_70637_d(boolean jumping) {
        super.func_70637_d(jumping);
        if (jumping) {
            this.func_184185_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 57.29577951308232) - 90.0f;
    }

    private void enableJumpControl() {
        ((RabbitJumpHelper)this.field_70767_i).setCanJump(true);
    }

    private void disableJumpControl() {
        ((RabbitJumpHelper)this.field_70767_i).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    private int getRandomRabbitType() {
        Biome biome = this.field_70170_p.func_180494_b(new BlockPos((Entity)this));
        int i = this.field_70146_Z.nextInt(100);
        if (biome.func_150559_j()) {
            return i < 5 ? 7 : (i < 10 ? 6 : (i < 80 ? 1 : 3));
        }
        return i < 50 ? 0 : (i < 90 ? 5 : (i < 95 ? 2 : 4));
    }

    public static class RabbitJumpHelper
    extends EntityJumpHelper {
        private final EntityRabbitTFC rabbit;
        private boolean canJump;

        public RabbitJumpHelper(EntityRabbitTFC rabbit) {
            super((EntityLiving)rabbit);
            this.rabbit = rabbit;
        }

        public boolean isJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.rabbit.startJumping();
                this.field_75662_b = false;
            }
        }
    }

    static class AIPanic
    extends EntityAIPanic {
        private final EntityRabbitTFC rabbit;

        public AIPanic(EntityRabbitTFC rabbit, double speedIn) {
            super((EntityCreature)rabbit, speedIn);
            this.rabbit = rabbit;
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.rabbit.setMovementSpeed(this.field_75265_b);
        }
    }

    public static class RabbitTypeData
    implements IEntityLivingData {
        public int typeData;

        public RabbitTypeData(int type) {
            this.typeData = type;
        }
    }

    static class RabbitMoveHelper
    extends EntityMoveHelper {
        private final EntityRabbitTFC rabbit;
        private double nextJumpSpeed;

        public RabbitMoveHelper(EntityRabbitTFC rabbit) {
            super((EntityLiving)rabbit);
            this.rabbit = rabbit;
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (this.rabbit.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }

        public void func_75641_c() {
            if (this.rabbit.field_70122_E && !this.rabbit.field_70703_bu && !((RabbitJumpHelper)this.rabbit.field_70767_i).isJumping()) {
                this.rabbit.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                this.rabbit.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }
    }
}

