/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.egg.CapabilityEgg;
import net.dries007.tfc.api.capability.egg.IEgg;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.ILivestock;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.entity.animal.EntityChickenTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class EntityQuailTFC
extends EntityChickenTFC
implements ILivestock {
    public EntityQuailTFC(World worldIn) {
        this(worldIn, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityQuailTFC.getRandomGrowth(ConfigTFC.Animals.QUAIL.adulthood, ConfigTFC.Animals.QUAIL.elder));
    }

    public EntityQuailTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn, gender, birthDay);
        this.func_70105_a(0.7f, 0.7f);
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!BiomesTFC.isOceanicBiome(biome) && !BiomesTFC.isBeachBiome(biome) && biomeType == BiomeHelper.BiomeType.TEMPERATE_FOREST) {
            return ConfigTFC.Animals.QUAIL.rarity;
        }
        return 0;
    }

    @Override
    public int getDaysToAdulthood() {
        return ConfigTFC.Animals.QUAIL.adulthood;
    }

    @Override
    public int getDaysToElderly() {
        return ConfigTFC.Animals.QUAIL.elder;
    }

    @Override
    public List<ItemStack> getProducts() {
        IEgg cap;
        ArrayList<ItemStack> eggs = new ArrayList<ItemStack>();
        ItemStack egg = new ItemStack(Items.field_151110_aK);
        if (this.isFertilized() && (cap = (IEgg)egg.getCapability(CapabilityEgg.CAPABILITY, null)) != null) {
            EntityQuailTFC chick = new EntityQuailTFC(this.field_70170_p);
            chick.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
            cap.setFertilized((Entity)chick, (long)ConfigTFC.Animals.QUAIL.hatch + CalendarTFC.PLAYER_TIME.getTotalDays());
        }
        eggs.add(egg);
        return eggs;
    }

    @Override
    public long getProductsCooldown() {
        return Math.max(0L, (long)ConfigTFC.Animals.QUAIL.eggTicks + this.getLaidTicks() - CalendarTFC.PLAYER_TIME.getTicks());
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TFCSounds.ANIMAL_QUAIL_HURT;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return TFCSounds.ANIMAL_QUAIL_DEATH;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return TFCSounds.ANIMAL_QUAIL_SAY;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_QUAIL;
    }

    @Override
    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.14f, 0.9f);
    }

    @Override
    public double getOldDeathChance() {
        return ConfigTFC.Animals.QUAIL.oldDeathChance;
    }
}

