/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.IPredator;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.entity.ai.EntityAIAttackMeleeTFC;
import net.dries007.tfc.objects.entity.ai.EntityAIStandAttack;
import net.dries007.tfc.objects.entity.ai.EntityAIWanderHuntArea;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntityPolarBearTFC
extends EntityPolarBear
implements IAnimalTFC,
IPredator,
EntityAIStandAttack.IEntityStandAttack {
    private static final int DAYS_TO_ADULTHOOD = 180;
    private static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(EntityPolarBearTFC.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BIRTHDAY = EntityDataManager.func_187226_a(EntityPolarBearTFC.class, (DataSerializer)DataSerializers.field_187192_b);
    private int warningSoundTicks = 0;

    public EntityPolarBearTFC(World world) {
        this(world, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityAnimalTFC.getRandomGrowth(180, 0));
    }

    public EntityPolarBearTFC(World world, IAnimalTFC.Gender gender, int birthDay) {
        super(world);
        this.func_70105_a(1.4f, 1.7f);
        this.setGender(gender);
        this.setBirthDay(birthDay);
        this.setFamiliarity(0.0f);
        this.func_70873_a(0);
    }

    public EntityAgeable func_90011_a(@Nonnull EntityAgeable ageable) {
        return new EntityPolarBearTFC(this.field_70170_p, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), (int)CalendarTFC.PLAYER_TIME.getTotalDays());
    }

    protected void func_184651_r() {
        EntityAIWanderHuntArea wander = new EntityAIWanderHuntArea((EntityCreature)this, 1.0);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, new EntityAIStandAttack<EntityPolarBearTFC>(this, 1.2, 2.0, EntityAIAttackMeleeTFC.AttackBehavior.DAYLIGHT_ONLY).setWanderAI(wander));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)wander);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        int priority = 2;
        for (String input : ConfigTFC.Animals.POLAR_BEAR.huntCreatures) {
            Class entityClass;
            ResourceLocation key = new ResourceLocation(input);
            EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(key);
            if (entityEntry == null || !EntityLivingBase.class.isAssignableFrom(entityClass = entityEntry.getEntityClass())) continue;
            this.field_70715_bh.func_75776_a(priority++, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, entityClass, false));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
    }

    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_POLAR_BEAR;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(GENDER, (Object)true);
        this.func_184212_Q().func_187214_a(BIRTHDAY, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 100 == 0) {
            this.func_98054_a(false);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public boolean func_70652_k(@Nonnull Entity entityIn) {
        boolean flag;
        double attackDamage = this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (this.func_70631_g_()) {
            attackDamage /= 2.0;
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)attackDamage)) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    @Override
    public void setStand(boolean standing) {
        super.func_189794_p(standing);
    }

    @Override
    public void playWarning() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, 1.0f);
            this.warningSoundTicks = 40;
        }
    }

    @Override
    public IAnimalTFC.Gender getGender() {
        return IAnimalTFC.Gender.valueOf((Boolean)this.field_70180_af.func_187225_a(GENDER));
    }

    @Override
    public void setGender(IAnimalTFC.Gender gender) {
        this.field_70180_af.func_187227_b(GENDER, (Object)gender.toBool());
    }

    @Override
    public int getBirthDay() {
        return (Integer)this.field_70180_af.func_187225_a(BIRTHDAY);
    }

    @Override
    public void setBirthDay(int value) {
        this.field_70180_af.func_187227_b(BIRTHDAY, (Object)value);
    }

    @Override
    public float getAdultFamiliarityCap() {
        return 0.0f;
    }

    @Override
    public float getFamiliarity() {
        return 0.0f;
    }

    @Override
    public void setFamiliarity(float value) {
    }

    @Override
    public boolean isFertilized() {
        return false;
    }

    @Override
    public void setFertilized(boolean value) {
    }

    @Override
    public int getDaysToAdulthood() {
        return 180;
    }

    @Override
    public int getDaysToElderly() {
        return 0;
    }

    @Override
    public boolean isHungry() {
        return false;
    }

    @Override
    public IAnimalTFC.Type getType() {
        return IAnimalTFC.Type.MAMMAL;
    }

    @Override
    public TextComponentTranslation getAnimalName() {
        String entityString = EntityList.func_75621_b((Entity)this);
        return new TextComponentTranslation("tfc.animal." + entityString + "." + this.getGender().name().toLowerCase(), new Object[0]);
    }

    public void func_70873_a(int age) {
        super.func_70873_a(0);
    }

    public boolean func_70631_g_() {
        return this.getAge() == IAnimalTFC.Age.CHILD;
    }

    public void func_98054_a(boolean child) {
        double ageScale = 1.0 / (2.0 - this.getPercentToAdulthood());
        this.func_98055_j((float)ageScale);
    }

    @Nonnull
    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.getAnimalName().func_150254_d();
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!(BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome) || biomeType != BiomeHelper.BiomeType.TUNDRA && biomeType != BiomeHelper.BiomeType.TAIGA)) {
            return ConfigTFC.Animals.POLAR_BEAR.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.MOTHER_AND_CHILDREN_OR_SOLO_MALE;
    }

    @Override
    public int getMinGroupSize() {
        return 1;
    }

    @Override
    public int getMaxGroupSize() {
        return 3;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!this.func_110175_bO()) {
            this.func_175449_a(this.func_180425_c(), 80);
        }
    }

    public void func_70014_b(@Nonnull NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("gender", this.getGender().toBool());
        nbt.func_74768_a("birth", this.getBirthDay());
    }

    public void func_70037_a(@Nonnull NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setGender(IAnimalTFC.Gender.valueOf(nbt.func_74767_n("gender")));
        this.setBirthDay(nbt.func_74762_e("birth"));
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && BlocksTFC.isGround(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    public boolean func_70878_b(@Nonnull EntityAnimal otherAnimal) {
        return false;
    }
}

