/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity.animal;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.types.IAnimalTFC;
import net.dries007.tfc.api.types.IHuntable;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.LootTablesTFC;
import net.dries007.tfc.objects.entity.animal.AnimalGroupingRules;
import net.dries007.tfc.objects.entity.animal.EntityAnimalTFC;
import net.dries007.tfc.util.climate.BiomeHelper;
import net.dries007.tfc.world.classic.biomes.BiomesTFC;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

@ParametersAreNonnullByDefault
public class EntityPheasantTFC
extends EntityAnimalTFC
implements IHuntable {
    private static final int DAYS_TO_ADULTHOOD = 24;
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 1.0f;

    public EntityPheasantTFC(World worldIn) {
        this(worldIn, IAnimalTFC.Gender.valueOf(Constants.RNG.nextBoolean()), EntityPheasantTFC.getRandomGrowth(24, 0));
    }

    public EntityPheasantTFC(World worldIn, IAnimalTFC.Gender gender, int birthDay) {
        super(worldIn, gender, birthDay);
        this.func_70105_a(0.9f, 0.9f);
    }

    @Override
    public int getSpawnWeight(Biome biome, float temperature, float rainfall, float floraDensity, float floraDiversity) {
        BiomeHelper.BiomeType biomeType = BiomeHelper.getBiomeType(temperature, rainfall, floraDensity);
        if (!(BiomesTFC.isOceanicBiome(biome) || BiomesTFC.isBeachBiome(biome) || biomeType != BiomeHelper.BiomeType.TROPICAL_FOREST && biomeType != BiomeHelper.BiomeType.TAIGA)) {
            return ConfigTFC.Animals.PHEASANT.rarity;
        }
        return 0;
    }

    @Override
    public BiConsumer<List<EntityLiving>, Random> getGroupingRules() {
        return AnimalGroupingRules.ELDER_AND_POPULATION;
    }

    @Override
    public int getMinGroupSize() {
        return 1;
    }

    @Override
    public int getMaxGroupSize() {
        return 4;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 1.0f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
    }

    @Override
    public double getOldDeathChance() {
        return 0.0;
    }

    @Override
    public int getDaysToAdulthood() {
        return 24;
    }

    @Override
    public int getDaysToElderly() {
        return 0;
    }

    @Override
    public IAnimalTFC.Type getType() {
        return IAnimalTFC.Type.OVIPAROUS;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TFCSounds.ANIMAL_PHEASANT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFCSounds.ANIMAL_PHEASANT_DEATH;
    }

    protected void func_184651_r() {
        double speedMult = 1.3;
        EntityAnimalTFC.addWildPreyAI(this, speedMult);
        EntityAnimalTFC.addCommonPreyAI(this, speedMult);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    protected SoundEvent func_184639_G() {
        return TFCSounds.ANIMAL_PHEASANT_SAY;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTablesTFC.ANIMALS_PHEASANT;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.14f, 0.9f);
    }
}

